/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.custommap.view.android;

import android.view.View;
import net.zomis.custommap.CustomFacade;
import net.zomis.custommap.model.ITileModel;
import net.zomis.custommap.view.android.GameView;
import net.zomis.custommap.view.android.IAndroidGameView;
import net.zomis.custommap.view.android.MapPaintable;
import net.zomis.custommap.view.android.events.AndroidTileClickEvent;
import net.zomis.custommap.view.general.TileInterface;

public abstract class TileView<TM extends ITileModel<?>, MM extends GameView<? extends TM>>
extends MapPaintable
implements View.OnClickListener,
TileInterface<TM> {
    protected TM model;
    protected final MM mapView;

    public MM getMapView() {
        return this.mapView;
    }

    public TileView(MM mapView, TM model) {
        super((IAndroidGameView)mapView);
        this.mapView = mapView;
        this.model = model;
        if (mapView != null) {
            this.x = this.model.getX() * ((GameView)mapView).tileSize;
            this.y = this.model.getY() * ((GameView)mapView).tileSize;
        }
        this.updatePosition();
        if (this.image != null) {
            this.image.setOnClickListener(this);
        }
    }

    @Override
    public void updatePosition() {
        if (this.view == null) {
            return;
        }
        if (this.image == null) {
            return;
        }
        if (this.model == null) {
            return;
        }
        this.x = this.getXPos() * this.getTileSize();
        this.y = this.getYPos() * this.getTileSize();
        this.image.layout(this.x, this.y, this.x + this.getTileSize(), this.y + this.getTileSize());
    }

    @Override
    public TM getModel() {
        return this.model;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getXPos() {
        return this.model.getX();
    }

    @Override
    public int getYPos() {
        return this.model.getY();
    }

    @Override
    public abstract void update();

    public void onClick(View view) {
        CustomFacade.getGlobalEvents().executeEvent(new AndroidTileClickEvent(this));
    }

    public String toString() {
        return "TileView for " + this.model;
    }
}

