/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.custommap.view.android;

import android.view.GestureDetector;
import android.view.MotionEvent;
import net.zomis.custommap.CustomFacade;
import net.zomis.custommap.view.android.IAndroidGameView;
import net.zomis.custommap.view.android.events.AndroidDoubleTapEvent;
import net.zomis.custommap.view.android.events.AndroidFlingEvent;
import net.zomis.custommap.view.android.events.AndroidScrollEvent;
import net.zomis.custommap.view.android.events.CustommapLongPressMapEvent;

public class GestureListener
extends GestureDetector.SimpleOnGestureListener {
    private IAndroidGameView mapView;
    private boolean returnOnFling = false;
    private boolean returnOnScroll = false;
    private boolean returnOnDown = false;
    private boolean returnOnDoubleTap = false;

    public GestureListener(IAndroidGameView mapView) {
        this.mapView = mapView;
    }

    public boolean onDoubleTap(MotionEvent e) {
        if (!this.mapView.isInputEnabled()) {
            return false;
        }
        CustomFacade.getGlobalEvents().executeEvent(new AndroidDoubleTapEvent(e, this.mapView));
        return this.returnOnDoubleTap;
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (!this.mapView.isInputEnabled()) {
            return false;
        }
        CustomFacade.getGlobalEvents().executeEvent(new AndroidFlingEvent(e1, e2, velocityX, velocityY, this.mapView));
        return this.returnOnFling;
    }

    public void onLongPress(MotionEvent e) {
        if (!this.mapView.isInputEnabled()) {
            return;
        }
        CustomFacade.getGlobalEvents().executeEvent(new CustommapLongPressMapEvent(e, this.mapView));
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (!this.mapView.isInputEnabled()) {
            return false;
        }
        if (this.mapView == null) {
            CustomFacade.getLog().w("onScroll map null");
            return false;
        }
        if (e1 == null) {
            CustomFacade.getLog().v("onScroll e1 null - this seems to happen when dragging an object");
            return false;
        }
        if (e2 == null) {
            CustomFacade.getLog().w("onScroll e2 null");
            return false;
        }
        CustomFacade.getGlobalEvents().executeEvent(new AndroidScrollEvent(e1, e2, distanceX, distanceY, this.mapView));
        return this.returnOnScroll;
    }

    public boolean onDown(MotionEvent e) {
        if (!this.mapView.isInputEnabled()) {
            return false;
        }
        return this.returnOnDown;
    }
}

