/*
 * Decompiled with CFR 0.152.
 */
package net.zomis;

import java.lang.reflect.Method;
import java.util.Comparator;

public class BeanComparator<E>
implements Comparator<E> {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private Method method;
    private boolean isAscending;
    private boolean isIgnoreCase;
    private boolean isNullsLast = true;

    public BeanComparator(Class<?> beanClass, String methodName) {
        this(beanClass, methodName, true);
    }

    public BeanComparator(Class<?> beanClass, String methodName, boolean isAscending) {
        this(beanClass, methodName, isAscending, true);
    }

    public BeanComparator(Class<?> beanClass, String methodName, boolean isAscending, boolean isIgnoreCase) {
        this.setAscending(isAscending);
        this.setIgnoreCase(isIgnoreCase);
        try {
            this.method = beanClass.getMethod(methodName, EMPTY_CLASS_ARRAY);
        }
        catch (NoSuchMethodException nsme) {
            String message = methodName + "() method does not exist";
            throw new IllegalArgumentException(message);
        }
        Class<?> returnClass = this.method.getReturnType();
        if (returnClass.getName().equals("void")) {
            String message = methodName + " has a void return type";
            throw new IllegalArgumentException(message);
        }
    }

    public void setAscending(boolean isAscending) {
        this.isAscending = isAscending;
    }

    public void setIgnoreCase(boolean isIgnoreCase) {
        this.isIgnoreCase = isIgnoreCase;
    }

    public void setNullsLast(boolean isNullsLast) {
        this.isNullsLast = isNullsLast;
    }

    @Override
    public int compare(Object object1, Object object2) {
        Object c2;
        Object c1;
        Object field1 = null;
        Object field2 = null;
        try {
            field1 = this.method.invoke(object1, EMPTY_OBJECT_ARRAY);
            field2 = this.method.invoke(object2, EMPTY_OBJECT_ARRAY);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (field1 instanceof String && ((String)field1).length() == 0) {
            field1 = null;
        }
        if (field2 instanceof String && ((String)field2).length() == 0) {
            field2 = null;
        }
        if (field1 == null && field2 == null) {
            return 0;
        }
        if (field1 == null) {
            return this.isNullsLast ? 1 : -1;
        }
        if (field2 == null) {
            return this.isNullsLast ? -1 : 1;
        }
        if (this.isAscending) {
            c1 = field1;
            c2 = field2;
        } else {
            c1 = field2;
            c2 = field1;
        }
        if (c1 instanceof Comparable) {
            if (c1 instanceof String && this.isIgnoreCase) {
                return ((String)c1).compareToIgnoreCase((String)c2);
            }
            return ((Comparable)c1).compareTo(c2);
        }
        if (this.isIgnoreCase) {
            return c1.toString().compareToIgnoreCase(c2.toString());
        }
        return c1.toString().compareTo(c2.toString());
    }
}

