/*
 * Decompiled with CFR 0.152.
 */
package com.mgs.trees;

import com.mgs.trees.ExpandAction;
import com.mgs.trees.ExpandTreeStrategy;
import com.mgs.trees.Node;
import com.mgs.trees.TreeResult;
import java.util.ArrayList;
import java.util.Iterator;

public class TreeFactory<T> {
    private final ExpandTreeStrategy<T> expandTreeStrategy;

    public TreeFactory(ExpandTreeStrategy<T> expandTreeStrategy) {
        this.expandTreeStrategy = expandTreeStrategy;
    }

    public TreeResult<T> buildTree(T seed) {
        ExpandAction<T> expandActionResult = this.expandTreeStrategy.expand(seed);
        if (expandActionResult.isStopBranch()) {
            return TreeResult.stopBranch(seed);
        }
        if (expandActionResult.isStopTree()) {
            return TreeResult.stopTree(seed);
        }
        Node<Node<T>> rootNode = new Node<Node<T>>(seed);
        ArrayList currentBranch = new ArrayList();
        currentBranch.add(rootNode);
        Iterator<T> childIterator = expandActionResult.getChildIterator();
        TreeResult<T> lastSubTreeResult = null;
        while (childIterator.hasNext()) {
            Node<T> next = new Node<T>(childIterator.next());
            lastSubTreeResult = this.buildTree(next.getContent());
            rootNode.addChild(lastSubTreeResult.getTree().getRootNode());
            if (!lastSubTreeResult.isBuildInterrupted()) continue;
            currentBranch.addAll(lastSubTreeResult.getLastNodeBranch());
            return TreeResult.interrupt(rootNode, currentBranch);
        }
        if (lastSubTreeResult == null) {
            throw new NullPointerException("Did you continue without any children?");
        }
        currentBranch.addAll(lastSubTreeResult.getLastNodeBranch());
        return TreeResult.buildCompleted(rootNode, currentBranch);
    }
}

