/*
 * Decompiled with CFR 0.152.
 */
package com.mgs.trees;

import com.mgs.trees.IteratorStrategy;
import com.mgs.trees.Node;
import com.mgs.trees.Tree;
import java.util.Iterator;
import java.util.List;

public class DefaultIterator<T>
implements IteratorStrategy<T> {
    @Override
    public Iterator<Node<T>> createIterator(Tree<T> tree) {
        return new MyIterator<T>(tree.getRootNode());
    }

    public static class MyIterator<T>
    implements Iterator<Node<T>> {
        private Node<T> toBeNext;

        public MyIterator(Node<T> rootNode) {
            this.toBeNext = rootNode;
        }

        @Override
        public boolean hasNext() {
            return this.toBeNext != null;
        }

        @Override
        public Node<T> next() {
            Node<T> toReturn = this.toBeNext;
            this.toBeNext = this.getNext(this.toBeNext);
            return toReturn;
        }

        private Node<T> getNext(Node<T> previous) {
            List<Node<T>> childs = previous.getChilds();
            return childs == null || childs.size() == 0 ? null : childs.get(0);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

