/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.base;

import com.cardshifter.modapi.actions.ActionComponent;
import com.cardshifter.modapi.actions.ECSAction;
import com.cardshifter.modapi.actions.TargetSet;
import com.cardshifter.modapi.base.ComponentRetriever;
import com.cardshifter.modapi.base.CreatureTypeComponent;
import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.base.PlayerComponent;
import com.cardshifter.modapi.base.Retriever;
import com.cardshifter.modapi.base.RetrieverSingleton;
import com.cardshifter.modapi.base.Retrievers;
import com.cardshifter.modapi.cards.BattlefieldComponent;
import com.cardshifter.modapi.cards.CardComponent;
import com.cardshifter.modapi.cards.DeckComponent;
import com.cardshifter.modapi.cards.HandComponent;
import com.cardshifter.modapi.cards.ZoneComponent;
import com.cardshifter.modapi.phase.PhaseController;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ECSResourceData;
import com.cardshifter.modapi.resources.ResourceRetriever;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;

public abstract class GameTest {
    private static final Logger logger = LogManager.getLogger(GameTest.class);
    protected ECSGame game;
    @Retriever
    protected ComponentRetriever<ActionComponent> actions;
    @Retriever
    protected ComponentRetriever<CardComponent> card;
    @Retriever
    protected ComponentRetriever<DeckComponent> deck;
    @Retriever
    protected ComponentRetriever<HandComponent> hand;
    @Retriever
    protected ComponentRetriever<BattlefieldComponent> field;
    @Retriever
    protected ComponentRetriever<CreatureTypeComponent> ctype;
    @RetrieverSingleton
    protected PhaseController phase;

    @Before
    public void before() {
        this.game = new ECSGame();
        this.game.setRandomSeed(42L);
        this.setupGame(this.game);
        Retrievers.inject((Object)this, (ECSGame)this.game);
        this.game.startGame();
        this.onAfterGameStart();
    }

    protected abstract void onAfterGameStart();

    protected abstract void setupGame(ECSGame var1);

    protected Entity getOpponent() {
        List list = this.game.getEntitiesWithComponent(PlayerComponent.class).stream().filter(entity -> entity != this.phase.getCurrentEntity()).collect(Collectors.toList());
        Assert.assertEquals((String)"Found more than one opponent", (long)1L, (long)list.size());
        return (Entity)list.get(0);
    }

    protected Predicate<Entity> isCreatureType(String creatureType) {
        return entity -> entity.hasComponent(CreatureTypeComponent.class) && ((CreatureTypeComponent)entity.getComponent(CreatureTypeComponent.class)).getCreatureType().equals(creatureType);
    }

    protected void assertResource(Entity entity, ECSResource resource, int expected) {
        ResourceRetriever retriever = ResourceRetriever.forResource((ECSResource)resource);
        ECSResourceData res = retriever.resFor(entity);
        Assert.assertEquals((String)("Unexpected resource " + resource + " for " + entity), (long)expected, (long)res.get());
    }

    protected void useActionWithFailedTarget(Entity source, String actionName, Entity target) {
        ECSAction action = this.getAction(source, actionName);
        Objects.requireNonNull(action, source + " does not have action " + actionName);
        Assert.assertTrue((boolean)action.isAllowed(this.phase.getCurrentEntity()));
        Assert.assertEquals((long)1L, (long)action.getTargetSets().size());
        TargetSet targets = (TargetSet)action.getTargetSets().get(0);
        Assert.assertFalse((String)"Did not expect target to be allowed", (boolean)targets.addTarget(target));
        Assert.assertFalse((String)"Did not expect action to be performed", (boolean)action.perform(this.phase.getCurrentEntity()));
    }

    protected List<Entity> findPossibleTargets(Entity entity, String actionName) {
        ECSAction action = this.getAction(entity, actionName);
        Assert.assertTrue((boolean)action.isAllowed(this.phase.getCurrentEntity()));
        Assert.assertEquals((long)1L, (long)action.getTargetSets().size());
        TargetSet targets = (TargetSet)action.getTargetSets().get(0);
        return targets.findPossibleTargets();
    }

    protected void useActionWithTarget(Entity entity, String actionName, Entity target) {
        ECSAction action = this.getAction(entity, actionName);
        Assert.assertTrue((boolean)action.isAllowed(this.phase.getCurrentEntity()));
        Assert.assertEquals((String)"Unexpected numbet of TargetSets.", (long)1L, (long)action.getTargetSets().size());
        TargetSet targets = (TargetSet)action.getTargetSets().get(0);
        Assert.assertTrue((String)("Target could not be added: " + target + " to action " + action), (boolean)targets.addTarget(target));
        Assert.assertTrue((String)(action + " could not be performed"), (boolean)action.perform(this.phase.getCurrentEntity()));
    }

    protected void useFail(Entity entity, String actionName) {
        this.useFail(entity, actionName, this.phase.getCurrentEntity());
    }

    protected void useFail(Entity entity, String actionName, Entity performer) {
        ECSAction action = this.getAction(entity, actionName);
        Assert.assertFalse((String)("Did not expect action " + actionName + " to be allowed on " + entity + " by " + performer), (boolean)action.isAllowed(performer));
    }

    protected Entity findCardInDeck(Predicate<Entity> condition) {
        return ((DeckComponent)this.deck.get(this.phase.getCurrentEntity())).stream().filter(condition).findAny().get();
    }

    protected Entity cardToHand(Predicate<Entity> condition) {
        Entity player = this.phase.getCurrentEntity();
        HandComponent myHand = (HandComponent)this.hand.get(player);
        Optional<Entity> inHand = myHand.stream().filter(condition).findAny();
        if (!inHand.isPresent()) {
            int previousHand = myHand.size();
            Entity inDeck = this.findCardInDeck(condition);
            ((CardComponent)this.card.get(inDeck)).moveToBottom((ZoneComponent)myHand);
            ((CardComponent)this.card.get(myHand.getTopCard())).moveToBottom((ZoneComponent)this.deck.get(player));
            Assert.assertEquals((long)previousHand, (long)myHand.size());
            return inDeck;
        }
        return inHand.get();
    }

    protected void nextPhase() {
        this.useAction(this.phase.getCurrentEntity(), "End Turn");
        logger.info((Object)("Next phase, current entity is now " + this.phase.getCurrentEntity() + " phase is " + this.phase.getCurrentPhase()));
    }

    protected void useAction(Entity entity, String actionName) {
        ECSAction action = this.getAction(entity, actionName);
        Assert.assertTrue((String)("Action " + actionName + " is not allowed for " + entity), (boolean)action.isAllowed(this.phase.getCurrentEntity()));
        action.perform(this.phase.getCurrentEntity());
    }

    protected ECSAction getAction(Entity entity, String actionName) {
        if (this.actions == null) {
            throw new AssertionError((Object)"actions is null");
        }
        ActionComponent available = (ActionComponent)Objects.requireNonNull(this.actions.get(entity), "Entity does not have any action component");
        return available.getAction(actionName);
    }

    protected Entity currentPlayer() {
        return this.phase.getCurrentEntity();
    }
}

