/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.resources;

import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ECSResourceData;
import com.cardshifter.modapi.resources.ECSResourceMap;
import java.util.Objects;
import java.util.Optional;

public class ResourceRetriever {
    private final ECSResource resource;

    ResourceRetriever(ECSResource resource) {
        this.resource = resource;
    }

    public static ResourceRetriever forResource(ECSResource resource) {
        return new ResourceRetriever(resource);
    }

    public int getFor(Entity entity) {
        return this.getOrDefault(entity, 0);
    }

    private ECSResourceMap resMap(Entity entity) {
        Objects.requireNonNull(entity, "Cannot retrieve resource map for null entity");
        if (entity.isRemoved()) {
            throw new IllegalArgumentException(entity + " has been marked for removal.");
        }
        ECSResourceMap map = entity.getComponent(ECSResourceMap.class);
        return Objects.requireNonNull(map, entity + " does not have a resource component: " + entity.getSuperComponents(Component.class));
    }

    public boolean has(Entity entity) {
        Objects.requireNonNull(entity, "Cannot retrieve resource map for null entity");
        ECSResourceMap map = entity.getComponent(ECSResourceMap.class);
        return map != null && this.resFor(entity) != null;
    }

    public ECSResourceData resFor(Entity entity) {
        return this.resMap(entity).getResource(this.resource);
    }

    public void set(Entity entity, int value) {
        ECSResourceMap.createOrGetFor(entity).set(this.resource, value);
    }

    public ECSResource getResource() {
        return this.resource;
    }

    public int getOrDefault(Entity entity, int defaultValue) {
        Objects.requireNonNull(entity, "Cannot retrieve resource map for null entity");
        ECSResourceMap map = entity.getComponent(ECSResourceMap.class);
        if (map == null) {
            return defaultValue;
        }
        Optional<ECSResourceData> resData = map.get(this.resource);
        return !resData.isPresent() ? defaultValue : resData.get().get();
    }
}

