/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.phase;

import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.ECSSystem;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.phase.PhaseStartEvent;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ECSResourceMap;
import net.zomis.cardshifter.ecs.effects.EntityInt;

public class GainResourceSystem
implements ECSSystem {
    private final ECSResource resource;
    private final EntityInt valueGet;

    public GainResourceSystem(ECSResource resource, EntityInt object) {
        this.resource = resource;
        this.valueGet = object;
    }

    @Override
    public void startGame(ECSGame game) {
        game.getEvents().registerHandlerAfter(this, PhaseStartEvent.class, turn -> {
            Entity entity = turn.getNewPhase().getOwner();
            ECSResourceMap map = entity.getComponent(ECSResourceMap.class);
            int value = this.valueGet.valueFor(entity);
            map.getResource(this.resource).change(value);
        });
    }

    public String toString() {
        return "GainResourceSystem [resource=" + this.resource + ", valueGet=" + this.valueGet + "]";
    }
}

