/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.cards;

import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.ECSSystem;
import com.cardshifter.modapi.cards.DrawCardFailedEvent;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ResourceRetriever;

public class DamageConstantWhenOutOfCardsSystem
implements ECSSystem {
    private final int damage;
    private final ResourceRetriever resource;

    public DamageConstantWhenOutOfCardsSystem(ECSResource resource, int damage) {
        this.damage = damage;
        this.resource = ResourceRetriever.forResource(resource);
    }

    @Override
    public void startGame(ECSGame game) {
        game.getEvents().registerHandlerAfter(this, DrawCardFailedEvent.class, this::damage);
    }

    private void damage(DrawCardFailedEvent event) {
        this.resource.resFor(event.getEntity()).change(-this.damage);
    }

    public String toString() {
        return "DamageConstantWhenOutOfCardsSystem [damage=" + this.damage + ", resource=" + this.resource + "]";
    }
}

