/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.base;

import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.Entity;
import java.util.Objects;
import java.util.Set;

public class ComponentRetriever<T extends Component> {
    private final Class<T> clazz;

    public ComponentRetriever(Class<T> clazz) {
        this.clazz = clazz;
    }

    public boolean has(Entity entity) {
        return entity.hasComponent(this.clazz);
    }

    public T get(Entity entity) {
        Objects.requireNonNull(entity, "Cannot retrieve component " + this.clazz.getSimpleName() + " on a null entity");
        return entity.getComponent(this.clazz);
    }

    public T required(Entity entity) {
        String removed = entity.isRemoved() ? " Entity has been removed!" : "";
        return (T)((Component)Objects.requireNonNull(this.get(entity), this.clazz.getName() + " not found on entity: " + entity + " available components is: " + entity.getSuperComponents(Component.class) + removed));
    }

    public static <T extends Component> ComponentRetriever<T> retreiverFor(Class<T> clazz) {
        return new ComponentRetriever<T>(clazz);
    }

    public static <T extends Component> ComponentRetriever<T> singleton(final Class<T> class1) {
        return new ComponentRetriever<T>(null){

            @Override
            public boolean has(Entity entity) {
                return this.get(entity) != null;
            }

            @Override
            public T get(Entity entity) {
                return 1.singleton(entity.getGame(), class1);
            }
        };
    }

    public static <T extends Component> T singleton(ECSGame game, Class<T> class1) {
        Set<Entity> all = game.getEntitiesWithComponent(class1);
        if (all.size() != 1) {
            throw new IllegalStateException("Expected to find exactly one " + class1.getSimpleName() + ", found " + all.size());
        }
        return all.iterator().next().getComponent(class1);
    }

    public static <T extends Component> T singletonOptional(ECSGame game, Class<T> class1) {
        Set<Entity> all = game.getEntitiesWithComponent(class1);
        if (all.size() > 1) {
            throw new IllegalStateException("Expected to find exactly one " + class1.getSimpleName() + ", found " + all.size());
        }
        return all.isEmpty() ? null : (T)all.iterator().next().getComponent(class1);
    }
}

