/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.attributes;

import com.cardshifter.modapi.attributes.ECSAttribute;
import com.cardshifter.modapi.attributes.ECSAttributeData;
import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.CopyableComponent;
import com.cardshifter.modapi.base.Entity;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class ECSAttributeMap
extends Component
implements CopyableComponent {
    private final Map<ECSAttribute, ECSAttributeData> map = new HashMap<ECSAttribute, ECSAttributeData>();

    private ECSAttributeMap() {
    }

    public ECSAttributeMap set(ECSAttribute attr, String value) {
        ECSAttributeData data = this.getAttribute(attr);
        data.set(value);
        return this;
    }

    public ECSAttributeData getAttribute(ECSAttribute attr) {
        this.map.computeIfAbsent(attr, r -> new ECSAttributeData(this.getEntity(), (ECSAttribute)r));
        return this.map.get(attr);
    }

    public static ECSAttributeMap createFor(Entity entity) {
        ECSAttributeMap attr = new ECSAttributeMap();
        entity.addComponent(attr);
        return attr;
    }

    public static ECSAttributeMap createOrGetFor(Entity entity) {
        ECSAttributeMap attr = entity.getComponent(ECSAttributeMap.class);
        if (attr == null) {
            attr = new ECSAttributeMap();
            entity.addComponent(attr);
        }
        return attr;
    }

    public String toString() {
        return this.map.toString();
    }

    public Stream<ECSAttributeData> getAttributes() {
        return this.map.values().stream();
    }

    @Override
    public Component copy(Entity copyTo) {
        ECSAttributeMap copy = new ECSAttributeMap();
        for (ECSAttributeData data : this.map.values()) {
            ECSAttributeData copyData = data.copy(copyTo);
            copy.map.put(data.getAttribute(), copyData);
        }
        return copy;
    }
}

