/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.actions.attack;

import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.ECSSystem;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.cards.BattlefieldComponent;
import com.cardshifter.modapi.phase.PhaseEndEvent;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ResourceRetriever;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AttackDamageHealAtEndOfTurn
implements ECSSystem {
    private final ResourceRetriever health;
    private final ResourceRetriever maxHealth;

    public AttackDamageHealAtEndOfTurn(ECSResource health, ECSResource maxHealth) {
        this.health = ResourceRetriever.forResource(health);
        this.maxHealth = ResourceRetriever.forResource(maxHealth);
    }

    @Override
    public void startGame(ECSGame game) {
        game.getEvents().registerHandlerAfter(this, PhaseEndEvent.class, this::heal);
    }

    private void heal(PhaseEndEvent event) {
        Entity owner = event.getOldPhase().getOwner();
        if (owner == null) {
            return;
        }
        Set<Entity> battlefielders = owner.getGame().getEntitiesWithComponent(BattlefieldComponent.class);
        List cards = battlefielders.stream().map(entity -> entity.getComponent(BattlefieldComponent.class)).flatMap(comp -> comp.stream()).collect(Collectors.toList());
        for (Entity card : cards) {
            if (!this.maxHealth.has(card)) continue;
            this.health.resFor(card).set(this.maxHealth.getFor(card));
        }
    }
}

