/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.actions;

import com.cardshifter.modapi.actions.ECSAction;
import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.CopyableComponent;
import com.cardshifter.modapi.base.Entity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ActionComponent
extends Component
implements CopyableComponent {
    private final Map<String, ECSAction> actions = new HashMap<String, ECSAction>();

    public ActionComponent addAction(ECSAction action) {
        this.actions.put(action.getName(), action);
        return this;
    }

    public Set<String> getActions() {
        return this.actions.keySet();
    }

    public ECSAction getAction(String key) {
        return this.actions.get(key);
    }

    public Collection<ECSAction> getECSActions() {
        return new ArrayList<ECSAction>(this.actions.values());
    }

    public boolean removeAction(String actionName) {
        return this.actions.remove(actionName) != null;
    }

    @Override
    public Component copy(Entity copyTo) {
        ActionComponent copy = new ActionComponent();
        for (Map.Entry<String, ECSAction> entry : this.actions.entrySet()) {
            copy.addAction(entry.getValue().copy(copyTo));
        }
        return copy;
    }

    public String toString() {
        return "ActionComponent [actions=" + this.actions + "]";
    }
}

