/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.resources;

import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ECSResourceStrategy;
import com.cardshifter.modapi.resources.EntityModifier;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ResourceModifierComponent
extends Component
implements ECSResourceStrategy {
    private final Map<ECSResource, List<EntityModifier>> strategies = new HashMap<ECSResource, List<EntityModifier>>();

    public void addModifier(ECSResource resource, EntityModifier modifier) {
        this.strategies.putIfAbsent(resource, new LinkedList());
        List<EntityModifier> list = this.strategies.get(resource);
        list.add(modifier);
        list.sort(Comparator.comparingInt(em -> em.getPriority()));
    }

    @Override
    public int getResource(Entity entity, ECSResource resource, int actualValue) {
        Iterable modifiers = this.strategies.get(resource);
        if (modifiers == null) {
            return actualValue;
        }
        int value = actualValue;
        for (EntityModifier modifier : modifiers) {
            if (!modifier.isActive() || !modifier.appliesTo(entity)) continue;
            value = modifier.getResource(entity, resource, value);
        }
        return value;
    }
}

