/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.resources;

import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ECSResourceBiStrategy;
import com.cardshifter.modapi.resources.ECSResourceStrategy;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class EntityModifier
implements ECSResourceStrategy {
    private final Entity source;
    private final int priority;
    private final Predicate<Entity> active;
    private final BiPredicate<Entity, Entity> appliesTo;
    private final ECSResourceBiStrategy amount;

    public EntityModifier(Entity entity, int priority, Predicate<Entity> active, BiPredicate<Entity, Entity> appliesTo, ECSResourceBiStrategy amount) {
        this.source = entity;
        this.priority = priority;
        this.active = active;
        this.appliesTo = appliesTo;
        this.amount = amount;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean appliesTo(Entity target) {
        return this.appliesTo.test(this.source, target);
    }

    @Override
    public int getResource(Entity entity, ECSResource resource, int actualValue) {
        return this.amount.getResource(this.source, entity, resource, actualValue);
    }

    public boolean isActive() {
        return this.active.test(this.source);
    }
}

