/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.resources;

import com.cardshifter.modapi.base.ComponentRetriever;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ECSResourceStrategy;
import com.cardshifter.modapi.resources.ResourceModifierComponent;
import com.cardshifter.modapi.resources.ResourceValueChange;
import com.cardshifter.modapi.resources.ResourceViewUpdate;
import java.util.Objects;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ECSResourceData {
    private static final Logger logger = LogManager.getLogger(ECSResourceData.class);
    private int previousGet;
    private int current;
    private ECSResourceStrategy strategy;
    private final Entity entity;
    private final ECSResource resource;

    public ECSResourceData(Entity entity, ECSResource resource) {
        this.entity = Objects.requireNonNull(entity, "Entity cannot be null. Make sure that ResourceMap is added to an entity.");
        this.resource = Objects.requireNonNull(resource, "Resource cannot be null.");
        this.strategy = ComponentRetriever.singletonOptional(entity.getGame(), ResourceModifierComponent.class);
    }

    public int get() {
        int result;
        int n = result = this.strategy == null ? this.current : this.strategy.getResource(this.entity, this.resource, this.current);
        if (this.previousGet != result) {
            this.entity.getGame().getEvents().executePostEvent(new ResourceViewUpdate(this.entity, this.resource, result));
        }
        this.previousGet = result;
        return result;
    }

    public void set(int value) {
        if (this.current != value) {
            this.entity.getGame().executeEvent(new ResourceValueChange(this.entity, this.resource, this.get(), this.current, value), () -> {
                this.current = value;
                logger.debug((Object)("Modified " + this.resource + " for " + this.entity + " to " + value));
            });
        }
    }

    public void change(int value) {
        this.set(this.current + value);
    }

    public void setStrategy(ECSResourceStrategy strategy) {
        this.strategy = strategy;
    }

    public boolean has(int want) {
        return this.get() >= want;
    }

    public String toString() {
        return String.valueOf(this.current);
    }

    public ECSResource getResource() {
        return this.resource;
    }

    ECSResourceData copy(Entity copyTo) {
        ECSResourceData copy = new ECSResourceData(copyTo, this.resource);
        copy.current = this.current;
        copy.previousGet = this.previousGet;
        copy.strategy = this.strategy;
        return copy;
    }
}

