/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.base;

import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.ComponentRetriever;
import com.cardshifter.modapi.base.CopyableComponent;
import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.events.EntityRemoveEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class Entity {
    private Map<Class<? extends Component>, Component> components = new HashMap<Class<? extends Component>, Component>();
    private final int id;
    private final ECSGame game;
    private boolean removed;

    public Entity(ECSGame game, int id) {
        this.game = game;
        this.id = id;
    }

    public Entity addComponent(Component component) {
        this.components.put(component.getClass(), component);
        component.setEntity(this);
        return this;
    }

    public boolean hasComponent(Class<? extends Component> clazz) {
        return this.components.containsKey(clazz);
    }

    public <T extends Component> T getComponent(Class<T> clazz) {
        return (T)((Component)clazz.cast(this.components.get(clazz)));
    }

    public <T extends Component> T get(ComponentRetriever<T> retriever) {
        return retriever.get(this);
    }

    public int getId() {
        return this.id;
    }

    public ECSGame getGame() {
        return this.game;
    }

    public void addComponents(Component ... components) {
        for (Component component : components) {
            this.addComponent(component);
        }
    }

    public <T extends Component> Collection<T> getSuperComponents(Class<T> componentClass) {
        return this.components.entrySet().stream().filter(entry -> componentClass.isAssignableFrom((Class)entry.getKey())).map(entry -> (Component)componentClass.cast(entry.getValue())).collect(Collectors.toList());
    }

    public String toString() {
        return "Entity #" + this.id;
    }

    public void destroy() {
        this.getGame().executeEvent(new EntityRemoveEvent(this), () -> {
            this.components.clear();
            this.game.removeEntity(this);
            this.removed = true;
        });
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void removeComponent(Class<? extends Component> component) {
        this.components.remove(component);
    }

    public Entity copy() {
        if (this.isRemoved()) {
            throw new IllegalStateException("Unable to copy a removed entity");
        }
        Entity copy = this.game.newEntity();
        for (Component comp : this.components.values()) {
            if (!(comp instanceof CopyableComponent)) continue;
            CopyableComponent copyable = (CopyableComponent)((Object)comp);
            copy.addComponent(copyable.copy(copy));
        }
        return copy;
    }

    public Entity apply(Consumer<Entity> effect) {
        effect.accept(this);
        return this;
    }
}

