/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.base;

import com.cardshifter.modapi.base.CancellableEvent;
import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.ComponentRetriever;
import com.cardshifter.modapi.base.ECSGameState;
import com.cardshifter.modapi.base.ECSSystem;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.base.Retrievers;
import com.cardshifter.modapi.events.EventExecutor;
import com.cardshifter.modapi.events.GameOverEvent;
import com.cardshifter.modapi.events.IEvent;
import com.cardshifter.modapi.events.StartGameEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class ECSGame {
    private static final Logger logger = LogManager.getLogger(ECSGame.class);
    private final AtomicInteger ids = new AtomicInteger();
    private final Map<Integer, Entity> entities = new HashMap<Integer, Entity>();
    private final EventExecutor events = new EventExecutor();
    private final List<ECSSystem> systems = new ArrayList<ECSSystem>();
    private final Random random = new Random();
    private ECSGameState gameState = ECSGameState.NOT_STARTED;

    public Entity newEntity() {
        Entity entity = new Entity(this, this.ids.incrementAndGet());
        this.entities.put(entity.getId(), entity);
        return entity;
    }

    public <T extends IEvent> T executeEvent(T event, Runnable runInBetween) {
        return this.events.executeEvent(event, runInBetween);
    }

    public <T extends Component> ComponentRetriever<T> componentRetreiver(Class<T> class1) {
        return new ComponentRetriever<T>(class1);
    }

    public Set<Entity> getEntitiesWithComponent(Class<? extends Component> clazz) {
        return this.entities.values().stream().filter(e -> e.hasComponent(clazz)).collect(Collectors.toSet());
    }

    public EventExecutor getEvents() {
        return this.events;
    }

    public void addSystem(ECSSystem system) {
        logger.info((Object)("Add system: " + system));
        this.systems.add(system);
        Retrievers.inject(system, this);
        if (this.gameState != ECSGameState.NOT_STARTED) {
            system.startGame(this);
        }
    }

    public void startGame() {
        if (this.gameState != ECSGameState.NOT_STARTED) {
            throw new IllegalStateException("Game is already started");
        }
        this.systems.forEach(sys -> sys.startGame(this));
        this.gameState = ECSGameState.RUNNING;
        this.events.executePostEvent(new StartGameEvent(this));
    }

    public int randomRange(int min, int max) {
        return this.random.nextInt(max - min + 1) + min;
    }

    public Random getRandom() {
        return this.random;
    }

    public void endGame() {
        this.executeCancellableEvent(new GameOverEvent(this), () -> {
            this.gameState = ECSGameState.GAME_ENDED;
        });
    }

    public ECSGameState getGameState() {
        return this.gameState;
    }

    public boolean isGameOver() {
        return this.gameState == ECSGameState.GAME_ENDED;
    }

    void removeEntity(Entity entity) {
        this.entities.remove(entity.getId());
    }

    public List<Entity> findEntities(Predicate<Entity> condition) {
        return this.entities.values().stream().filter(condition).collect(Collectors.toList());
    }

    public <T extends CancellableEvent> T executeCancellableEvent(T event, Runnable runInBetween) {
        return this.events.executeCancellableEvent(event, runInBetween);
    }

    public Entity getEntity(int entity) {
        return this.entities.get(entity);
    }

    public void setRandomSeed(long seed) {
        this.random.setSeed(seed);
    }

    public <T extends ECSSystem> List<T> findSystemsOfClass(Class<T> clazz) {
        return this.systems.stream().filter(sys -> clazz.isAssignableFrom(sys.getClass())).map(obj -> (ECSSystem)clazz.cast(obj)).collect(Collectors.toList());
    }

    public boolean removeSystem(ECSSystem system) {
        logger.info((Object)("Remove system " + system));
        this.events.removeListenersWithIdentifier(system);
        return this.systems.remove(system);
    }
}

