/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.cardshifter.ecs.effects;

import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.ECSSystem;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.cards.BattlefieldComponent;
import com.cardshifter.modapi.cards.ZoneChangeEvent;
import com.cardshifter.modapi.events.EntityRemoveEvent;
import com.cardshifter.modapi.events.IEvent;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ECSResourceData;
import com.cardshifter.modapi.resources.ResourceRetriever;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import net.zomis.cardshifter.ecs.effects.EffectComponent;
import net.zomis.cardshifter.ecs.effects.GameEffect;
import net.zomis.cardshifter.ecs.effects.TargetEffect;
import net.zomis.cardshifter.ecs.effects.TargetFilter;

public class Effects {
    public <T extends IEvent> Function<Entity, ECSSystem> triggerSystem(final Class<T> eventClass, final BiPredicate<Entity, T> interestingEvents, BiConsumer<Entity, T> handler) {
        return e -> new ECSSystem((Entity)e, handler){
            final /* synthetic */ Entity val$e;
            final /* synthetic */ BiConsumer val$cap$2;
            {
                this.val$e = entity;
                this.val$cap$2 = biConsumer;
            }

            @Override
            public void startGame(ECSGame game) {
                game.getEvents().registerHandlerAfter(this, eventClass, this::event);
            }

            private void event(T event) {
                if (interestingEvents.test(this.val$e, event)) {
                    this.val$cap$2.accept(this.val$e, event);
                }
            }
        };
    }

    public EffectComponent forEach(TargetFilter filter, TargetEffect consumer) {
        GameEffect effect = event -> event.getEntity().getGame().findEntities(target -> filter.isTargetable(event.getEntity(), (Entity)target)).forEach(target -> consumer.perform(event.getEntity(), (Entity)target));
        return new EffectComponent("For each " + filter + ", " + consumer, effect);
    }

    public EffectComponent giveTarget(ECSResource resource, int value) {
        ResourceRetriever res = ResourceRetriever.forResource(resource);
        GameEffect effect = event -> event.getAction().getAllTargets().forEach(e -> res.resFor((Entity)e).change(value));
        return new EffectComponent("Give target " + value + " " + resource, effect);
    }

    public EffectComponent giveTarget(ECSResource resource, int value, IntUnaryOperator operator) {
        ResourceRetriever res = ResourceRetriever.forResource(resource);
        GameEffect effect = event -> event.getAction().getAllTargets().forEach(e -> {
            ECSResourceData data = res.resFor((Entity)e);
            data.change(value);
            data.set(operator.applyAsInt(data.get()));
        });
        return new EffectComponent("Give target " + value + " " + resource, effect);
    }

    public <T extends IEvent> EffectComponent giveTarget(Function<Entity, ECSSystem> system) {
        GameEffect effect = event -> event.getAction().getAllTargets().forEach(e -> e.getGame().addSystem(new InGameSystem((Entity)e, (ECSSystem)system.apply((Entity)e))));
        return new EffectComponent("Give target " + system, effect);
    }

    public <T extends IEvent> EffectComponent giveSelf(Function<Entity, ECSSystem> system) {
        GameEffect effect = event -> event.getEntity().getGame().addSystem(new InGameSystem(event.getEntity(), (ECSSystem)system.apply(event.getEntity())));
        return new EffectComponent("Give target " + system, effect);
    }

    public EffectComponent toSelf(Consumer<Entity> effect) {
        return new EffectComponent(effect.toString(), event -> effect.accept(event.getEntity()));
    }

    public Component described(String description, EffectComponent effectComponent) {
        return new EffectComponent(description, effectComponent.getEffect());
    }

    public EffectComponent systemWhileOnBattlefield(Function<Entity, ECSSystem> systemSupplier) {
        GameEffect effect = event -> event.getAction().getAllTargets().forEach(e -> e.getGame().addSystem(new InGameSystem((Entity)e, (ECSSystem)systemSupplier.apply((Entity)e))));
        return new EffectComponent("special system", effect);
    }

    public EffectComponent addSystem(Function<Entity, ECSSystem> systemSupplier) {
        GameEffect effect = e -> e.getEntity().getGame().addSystem((ECSSystem)systemSupplier.apply(e.getEntity()));
        return new EffectComponent("Add System", effect);
    }

    public static class InGameSystem
    implements ECSSystem {
        private final Entity owningEntity;
        private final ECSSystem systemToRemove;

        public InGameSystem(Entity owningEntity, ECSSystem system) {
            this.owningEntity = owningEntity;
            this.systemToRemove = system;
        }

        @Override
        public void startGame(ECSGame game) {
            game.getEvents().registerHandlerAfter(this.systemToRemove, EntityRemoveEvent.class, this::removeCheck);
            game.getEvents().registerHandlerAfter(this.systemToRemove, ZoneChangeEvent.class, this::removeCheck);
            game.addSystem(this.systemToRemove);
        }

        private void removeCheck(EntityRemoveEvent event) {
            if (event.getEntity() == this.owningEntity) {
                event.getEntity().getGame().removeSystem(this.systemToRemove);
            }
        }

        private void removeCheck(ZoneChangeEvent event) {
            if (event.getDestination() instanceof BattlefieldComponent) {
                return;
            }
            if (event.getCard() == this.owningEntity) {
                event.getCard().getGame().removeSystem(this.systemToRemove);
            }
        }
    }
}

