/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.resources;

import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.ECSSystem;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.phase.PhaseStartEvent;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ResourceRetriever;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;

public class RestoreResourcesToSystem
implements ECSSystem {
    private final Predicate<Entity> entityPredicate;
    private final ResourceRetriever resource;
    private final ToIntFunction<Entity> valueGetter;

    public RestoreResourcesToSystem(Predicate<Entity> entities, ECSResource resource, ToIntFunction<Entity> valueGetter) {
        this.entityPredicate = entities;
        this.resource = ResourceRetriever.forResource(resource);
        this.valueGetter = valueGetter;
    }

    @Override
    public void startGame(ECSGame game) {
        game.getEvents().registerHandlerAfter(this, PhaseStartEvent.class, this::restoreResources);
    }

    private void restoreResources(PhaseStartEvent event) {
        ECSGame game = event.getNewPhase().getOwner().getGame();
        List<Entity> entities = game.findEntities(this.entityPredicate);
        entities.forEach(this::restoreResource);
    }

    private void restoreResource(Entity entity) {
        int value = this.valueGetter.applyAsInt(entity);
        this.resource.resFor(entity).set(value);
    }

    public String toString() {
        return "RestoreResourcesToSystem [entityPredicate=" + this.entityPredicate + ", resource=" + this.resource + ", valueGetter=" + this.valueGetter + "]";
    }
}

