/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.cards;

import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.cards.CardComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class ZoneComponent
extends Component {
    private final LinkedList<Entity> cards = new LinkedList();
    private final Entity owner;
    private final Map<Entity, Boolean> known = new HashMap<Entity, Boolean>();
    private final String name;
    private final Entity zoneEntity;
    private boolean publicKnown;

    public ZoneComponent(Entity owner, String name) {
        this.owner = Objects.requireNonNull(owner, "Zone Owner cannot be null");
        this.name = Objects.requireNonNull(name, "Zone Name cannot be null");
        this.zoneEntity = owner.getGame().newEntity();
    }

    public Entity getOwner() {
        return this.owner;
    }

    public Entity getTopCard() {
        return this.cards.getFirst();
    }

    public boolean isKnownTo(Entity player) {
        return this.known.getOrDefault(player, this.publicKnown);
    }

    public void addOnBottom(Entity entity) {
        if (entity.hasComponent(CardComponent.class)) {
            throw new IllegalArgumentException("Entity " + entity + " already has CardComponent");
        }
        CardComponent comp = new CardComponent(null);
        entity.addComponent(comp);
        comp.moveToBottom(this);
    }

    public void shuffle() {
        Collections.shuffle(this.cards, this.getRandom());
    }

    public void setGloballyKnown(boolean publicKnown) {
        this.publicKnown = publicKnown;
    }

    protected void setKnown(Entity owner, boolean known) {
        this.known.put(owner, known);
    }

    public boolean isEmpty() {
        return this.cards.isEmpty();
    }

    public Entity getComponentEntity() {
        return this.getEntity();
    }

    void cardMoveFrom(Entity card) {
        this.cards.remove(card);
    }

    void cardMoveAtTop(Entity card) {
        this.cards.addFirst(card);
    }

    void cardMoveAtBottom(Entity card) {
        this.cards.addLast(card);
    }

    public void forEach(Consumer<? super Entity> action) {
        this.cards.forEach(action);
    }

    public int size() {
        return this.cards.size();
    }

    public String toString() {
        return "Zone '" + this.name + "' [size=" + this.size() + ", owner=" + this.owner + ", known=" + this.known + ", publicKnown=" + this.publicKnown + "]";
    }

    public Stream<Entity> stream() {
        return this.cards.stream();
    }

    public List<Entity> getCards() {
        return new ArrayList<Entity>(this.cards);
    }

    public String getName() {
        return this.name;
    }

    public int getZoneId() {
        return this.zoneEntity.getId();
    }
}

