/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.cards;

import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.cards.ZoneChangeEvent;
import com.cardshifter.modapi.cards.ZoneComponent;

public class CardComponent
extends Component {
    private ZoneComponent currentZone;

    public CardComponent(ZoneComponent zoneComponent) {
        this.currentZone = zoneComponent;
    }

    public Entity getOwner() {
        return this.getCurrentZone().getOwner();
    }

    public ZoneComponent getCurrentZone() {
        return this.currentZone;
    }

    public void moveToTop(ZoneComponent target) {
        this.moveTo(target, true);
    }

    public void moveToBottom(ZoneComponent target) {
        this.moveTo(target, false);
    }

    private void moveTo(ZoneComponent target, boolean top) {
        ZoneComponent dest;
        Entity card = this.getEntity();
        ZoneChangeEvent event = new ZoneChangeEvent(this.currentZone, target, card);
        this.executeEvent(event);
        if (event.getSource() != null) {
            event.getSource().cardMoveFrom(card);
        }
        if ((dest = event.getDestination()) != null) {
            if (top) {
                dest.cardMoveAtTop(card);
            } else {
                dest.cardMoveAtBottom(card);
            }
        }
        this.currentZone = dest;
    }
}

