/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.base;

import com.cardshifter.modapi.base.CancellableEvent;
import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.events.IEvent;
import java.util.Objects;
import java.util.Random;

public abstract class Component {
    private Entity entity;

    void setEntity(Entity entity) {
        if (this.entity != null) {
            throw new IllegalStateException("Component " + this + " is already connected to another entity.");
        }
        this.entity = entity;
    }

    protected final <T extends IEvent> T executeEvent(T event) {
        return this.getGame().getEvents().executePostEvent(event);
    }

    private ECSGame getGame() {
        Objects.requireNonNull(this.entity, "Component is not connected to an entity.");
        return this.entity.getGame();
    }

    protected final <T extends IEvent> T executeEvent(T event, Runnable runInBetween) {
        return this.entity.getGame().executeEvent(event, runInBetween);
    }

    protected final <T extends CancellableEvent> T executeCancellableEvent(T event, Runnable runInBetween) {
        return this.entity.getGame().executeCancellableEvent(event, runInBetween);
    }

    protected final Entity getEntity() {
        return this.entity;
    }

    protected final Random getRandom() {
        return this.getEntity().getGame().getRandom();
    }
}

