/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.actions;

import com.cardshifter.modapi.actions.ActionAllowedCheckEvent;
import com.cardshifter.modapi.actions.ActionPerformEvent;
import com.cardshifter.modapi.actions.TargetSet;
import com.cardshifter.modapi.base.Entity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ECSAction {
    private final Entity owner;
    private final String name;
    private final Predicate<ECSAction> allowed;
    private final Consumer<ECSAction> perform;
    private final List<TargetSet> targetSets = new ArrayList<TargetSet>();

    public ECSAction(Entity owner, String name, Predicate<ECSAction> allowed, Consumer<ECSAction> perform) {
        this.owner = owner;
        this.name = name;
        this.allowed = allowed;
        this.perform = perform;
    }

    public String getName() {
        return this.name;
    }

    public Entity getOwner() {
        return this.owner;
    }

    public ECSAction copy() {
        return this.copy(this.owner);
    }

    public ECSAction copy(Entity copyTo) {
        ECSAction action = new ECSAction(copyTo, this.name, this.allowed, this.perform);
        for (TargetSet set : this.targetSets) {
            action.addTargetSet(set.getMin(), set.getMax());
            TargetSet lastSet = action.getTargetSets().get(action.getTargetSets().size() - 1);
            set.getChosenTargets().forEach(target -> lastSet.addTarget((Entity)target));
        }
        return action;
    }

    public boolean perform(Entity performer) {
        if (!this.isAllowed(performer)) {
            return false;
        }
        if (!this.targetSets.stream().allMatch(targets -> targets.hasEnoughTargets())) {
            return false;
        }
        this.owner.getGame().executeEvent(new ActionPerformEvent(this.owner, this, performer), () -> this.perform.accept(this));
        this.targetSets.forEach(TargetSet::clearTargets);
        return true;
    }

    public boolean isAllowed(Entity performer) {
        ActionAllowedCheckEvent event = new ActionAllowedCheckEvent(this.owner, this, performer);
        if (!this.owner.getGame().getEvents().executePostEvent(event).isAllowed()) {
            return false;
        }
        return this.allowed.test(this);
    }

    public List<TargetSet> getTargetSets() {
        return new ArrayList<TargetSet>(this.targetSets);
    }

    public ECSAction addTargetSet(int min, int max) {
        this.targetSets.add(new TargetSet(this, min, max));
        return this;
    }

    public String toString() {
        return this.name + " for entity " + this.owner;
    }

    public Stream<Entity> getAllTargets() {
        return this.targetSets.stream().flatMap(e -> e.getChosenTargets().stream());
    }
}

