/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.cardshifter.ecs.effects;

import com.cardshifter.modapi.actions.ActionPerformEvent;
import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.CopyableComponent;
import com.cardshifter.modapi.base.Entity;
import net.zomis.cardshifter.ecs.effects.GameEffect;

public class EffectComponent
extends Component
implements CopyableComponent {
    private final GameEffect effect;
    private final String description;

    public EffectComponent(String description, GameEffect effect) {
        this.description = description;
        this.effect = effect;
    }

    public void perform(ActionPerformEvent entity) {
        this.effect.accept(entity);
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Component copy(Entity copyTo) {
        return new EffectComponent(this.description, this.effect);
    }

    public Component and(EffectComponent next) {
        return new EffectComponent(this.description + " and " + next.description, event -> this.effect.andThen(effectComponent.effect).accept((ActionPerformEvent)event));
    }
}

