/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.attributes;

import com.cardshifter.modapi.attributes.AttributeValueChange;
import com.cardshifter.modapi.attributes.AttributeViewUpdate;
import com.cardshifter.modapi.attributes.ECSAttribute;
import com.cardshifter.modapi.attributes.ECSAttributeStrategy;
import com.cardshifter.modapi.base.Entity;
import java.util.Objects;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ECSAttributeData {
    private static final Logger logger = LogManager.getLogger(ECSAttributeData.class);
    private String previousGet;
    private String current;
    private ECSAttributeStrategy strategy;
    private final Entity entity;
    private final ECSAttribute attribute;

    public ECSAttributeData(Entity entity, ECSAttribute attribute) {
        this.entity = Objects.requireNonNull(entity, "Entity cannot be null. Make sure that AttributeMap is added to an entity.");
        this.attribute = Objects.requireNonNull(attribute, "Attribute cannot be null.");
    }

    public String get() {
        String result;
        String string = result = this.strategy == null ? this.current : this.strategy.getAttribute(this.entity, this.current);
        if (!Objects.equals(this.previousGet, result)) {
            this.entity.getGame().getEvents().executePostEvent(new AttributeViewUpdate(this.entity, this.attribute, result));
        }
        this.previousGet = result;
        return result;
    }

    public void set(String value) {
        if (!Objects.equals(this.current, value)) {
            this.entity.getGame().executeEvent(new AttributeValueChange(this.entity, this.attribute, this.get(), this.current, value), () -> {
                this.current = value;
                logger.debug((Object)("Modified " + this.attribute + " for " + this.entity + " to " + value));
            });
        }
    }

    public void setStrategy(ECSAttributeStrategy strategy) {
        this.strategy = strategy;
    }

    public boolean contains(CharSequence value) {
        Objects.requireNonNull(value, "value");
        return this.current.contains(value);
    }

    public String toString() {
        return this.current;
    }

    public ECSAttribute getAttribute() {
        return this.attribute;
    }

    ECSAttributeData copy(Entity copyTo) {
        ECSAttributeData copy = new ECSAttributeData(copyTo, this.attribute);
        copy.current = this.current;
        copy.previousGet = this.previousGet;
        copy.strategy = this.strategy;
        return copy;
    }
}

