/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.actions;

import com.cardshifter.modapi.actions.ActionAllowedCheckEvent;
import com.cardshifter.modapi.actions.ActionPerformEvent;
import com.cardshifter.modapi.actions.SpecificActionSystem;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ECSResourceData;
import com.cardshifter.modapi.resources.ResourceRetriever;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;

public class UseCostSystem
extends SpecificActionSystem {
    private final ToIntFunction<Entity> cost;
    private final UnaryOperator<Entity> whoPays;
    private final ResourceRetriever useResource;

    public UseCostSystem(String action, ECSResource useResource, ToIntFunction<Entity> cost, UnaryOperator<Entity> whoPays) {
        super(action);
        this.useResource = ResourceRetriever.forResource(useResource);
        this.cost = cost;
        this.whoPays = whoPays;
    }

    @Override
    protected void isAllowed(ActionAllowedCheckEvent event) {
        int want;
        Entity payer = (Entity)this.whoPays.apply(event.getEntity());
        if (!this.useResource.has(payer)) {
            event.setAllowed(false);
            return;
        }
        ECSResourceData have = this.useResource.resFor(payer);
        if (!have.has(want = this.cost.applyAsInt(event.getEntity()))) {
            event.setAllowed(false);
        }
    }

    @Override
    protected void onPerform(ActionPerformEvent event) {
        if (event.getEntity().isRemoved()) {
            return;
        }
        ECSResourceData have = this.useResource.resFor((Entity)this.whoPays.apply(event.getEntity()));
        int want = this.cost.applyAsInt(event.getEntity());
        have.change(-want);
    }

    @Override
    public String toString() {
        return "UseCostSystem [action=" + this.getActionName() + ", useResource=" + this.useResource + "]";
    }
}

