/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.resources;

import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.CopyableComponent;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ECSResourceData;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class ECSResourceMap
extends Component
implements CopyableComponent {
    private final Map<ECSResource, ECSResourceData> map = new HashMap<ECSResource, ECSResourceData>();

    private ECSResourceMap() {
    }

    public ECSResourceMap set(ECSResource res, int value) {
        ECSResourceData data = this.getResource(res);
        data.set(value);
        return this;
    }

    public ECSResourceData getResource(ECSResource res) {
        this.map.computeIfAbsent(res, r -> new ECSResourceData(this.getEntity(), (ECSResource)r));
        return this.map.get(res);
    }

    public static ECSResourceMap createFor(Entity entity) {
        ECSResourceMap res = new ECSResourceMap();
        entity.addComponent(res);
        return res;
    }

    public String toString() {
        return this.map.toString();
    }

    public Stream<ECSResourceData> getResources() {
        return this.map.values().stream();
    }

    @Override
    public Component copy(Entity copyTo) {
        ECSResourceMap copy = new ECSResourceMap();
        for (ECSResourceData data : this.map.values()) {
            ECSResourceData copyData = data.copy(copyTo);
            copy.map.put(data.getResource(), copyData);
        }
        return copy;
    }
}

