/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.phase;

import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.ECSSystem;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.phase.PhaseStartEvent;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ECSResourceMap;
import java.util.function.ToIntFunction;

public class RestoreResourcesSystem
implements ECSSystem {
    private final ECSResource resource;
    private final ToIntFunction<Entity> valueGetter;

    public RestoreResourcesSystem(ECSResource resource, ToIntFunction<Entity> valueGetter) {
        this.resource = resource;
        this.valueGetter = valueGetter;
    }

    @Override
    public void startGame(ECSGame game) {
        game.getEvents().registerHandlerAfter(this, PhaseStartEvent.class, turn -> {
            Entity entity = turn.getNewPhase().getOwner();
            ECSResourceMap map = entity.getComponent(ECSResourceMap.class);
            int value = this.valueGetter.applyAsInt(entity);
            map.getResource(this.resource).set(value);
        });
    }

    public String toString() {
        return "RestoreResourcesSystem [resource=" + this.resource + ", valueGetter=" + this.valueGetter + "]";
    }
}

