/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.phase;

import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.phase.Phase;
import com.cardshifter.modapi.phase.PhaseEndEvent;
import com.cardshifter.modapi.phase.PhaseStartEvent;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.function.Predicate;

public class PhaseController
extends Component {
    private final LinkedList<Phase> upcomingPhases = new LinkedList();
    private final LinkedList<Phase> permanentPhases = new LinkedList();
    private int phaseNumber;
    private int recreateCount;

    public PhaseController addPhase(Phase phase) {
        this.permanentPhases.add(phase);
        this.upcomingPhases.add(phase);
        return this;
    }

    public void insertTemporaryPhaseNext(Phase phase) {
        this.upcomingPhases.add(1, phase);
    }

    public boolean insertTemporaryPhaseBefore(Phase phase, Predicate<Phase> beforePhase) {
        ListIterator<Phase> it = this.navigateToRecreate(beforePhase);
        if (it != null) {
            if (it.previousIndex() >= 0) {
                it.previous();
            }
            it.add(phase);
        }
        return it != null;
    }

    private ListIterator<Phase> navigateToRecreate(Predicate<Phase> after) {
        ListIterator<Phase> it = PhaseController.navigateTo(this.upcomingPhases.listIterator(), after);
        if (it == null) {
            int size = this.upcomingPhases.size();
            this.upcomingPhases.addAll(this.permanentPhases);
            it = PhaseController.navigateTo(this.upcomingPhases.listIterator(size), after);
            if (it == null) {
                return null;
            }
        }
        return it;
    }

    private static <T> ListIterator<T> navigateTo(ListIterator<T> iterator, Predicate<T> navigateAfter) {
        ListIterator<T> it = iterator;
        while (it.hasNext()) {
            T next = it.next();
            if (!navigateAfter.test(next)) continue;
            return it;
        }
        return null;
    }

    public boolean insertTemporaryPhaseAfter(Phase phase, Predicate<Phase> afterPhase) {
        ListIterator<Phase> it = this.navigateToRecreate(afterPhase);
        if (it != null) {
            it.add(phase);
        }
        return it != null;
    }

    public Phase getCurrentPhase() {
        this.refillPhases();
        return this.upcomingPhases.getFirst();
    }

    private void refillPhases() {
        if (this.upcomingPhases.isEmpty()) {
            this.upcomingPhases.addAll(this.permanentPhases);
        }
    }

    public Phase nextPhase() {
        Phase oldPhase = this.getCurrentPhase();
        this.executeEvent(new PhaseEndEvent(this, oldPhase));
        ++this.phaseNumber;
        this.upcomingPhases.removeFirst();
        Phase currentPhase = this.getCurrentPhase();
        if (currentPhase == this.permanentPhases.peekFirst()) {
            ++this.recreateCount;
        }
        this.executeEvent(new PhaseStartEvent(this, oldPhase, currentPhase));
        return currentPhase;
    }

    public Entity getCurrentEntity() {
        return this.getCurrentPhase().getOwner();
    }

    public int getPhaseNumber() {
        return this.phaseNumber;
    }

    public int getRecreateCount() {
        return this.recreateCount;
    }

    public void insertTemporaryPhaseBeforeCurrent(Phase phase) {
        this.upcomingPhases.addFirst(phase);
    }
}

