/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.resources;

import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ECSResourceData;
import com.cardshifter.modapi.resources.ECSResourceMap;
import com.cardshifter.modapi.resources.ResourceRetriever;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public final class Resources {
    private Resources() {
        throw new UnsupportedOperationException();
    }

    public static void processResources(Entity card, Consumer<ECSResourceData> consumer) {
        card.getComponent(ECSResourceMap.class).getResources().forEach(consumer);
    }

    public static Map<String, Integer> map(Entity playerFor) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Resources.processResources(playerFor, data -> result.put(data.getResource().toString(), data.get()));
        return result;
    }

    public static ResourceRetriever retriever(ECSResource resource) {
        return new ResourceRetriever(resource);
    }

    public static int getOrDefault(Entity entity, ECSResource resource, int defaultValue) {
        return ResourceRetriever.forResource(resource).getOrDefault(entity, defaultValue);
    }
}

