/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.phase;

import com.cardshifter.modapi.actions.ActionPerformEvent;
import com.cardshifter.modapi.actions.Actions;
import com.cardshifter.modapi.actions.ECSAction;
import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.ECSSystem;
import com.cardshifter.modapi.base.Retrievers;
import com.cardshifter.modapi.phase.PhaseController;
import com.cardshifter.modapi.phase.PhaseStartEvent;

public class LimitedActionsPerTurnSystem
implements ECSSystem {
    private int cardsPlayedThisTurn;
    private final int limit;
    private final String actionName;

    public LimitedActionsPerTurnSystem(int limit, String actionName) {
        this.limit = limit;
        this.actionName = actionName;
    }

    @Override
    public void startGame(ECSGame game) {
        game.getEvents().registerHandlerAfter(this, PhaseStartEvent.class, this::onNewTurn);
        game.getEvents().registerHandlerAfter(this, ActionPerformEvent.class, this::onCardPlayed);
    }

    private void onNewTurn(PhaseStartEvent event) {
        this.cardsPlayedThisTurn = 0;
    }

    private void onCardPlayed(ActionPerformEvent event) {
        if (event.getAction().getName().equals(this.actionName)) {
            return;
        }
        ++this.cardsPlayedThisTurn;
        if (this.cardsPlayedThisTurn >= this.limit) {
            if (this.actionName == null) {
                PhaseController phases = Retrievers.singleton(event.getEntity().getGame(), PhaseController.class);
                phases.nextPhase();
            } else {
                ECSAction action = Actions.getAction(event.getPerformer(), this.actionName);
                action.perform(event.getPerformer());
            }
            this.cardsPlayedThisTurn = 0;
        }
    }
}

