/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.events;

import com.cardshifter.modapi.base.CancellableEvent;
import com.cardshifter.modapi.events.EventExecution;
import com.cardshifter.modapi.events.EventHandler;
import com.cardshifter.modapi.events.IEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class EventExecutor
implements EventExecution {
    private static final Logger logger = LogManager.getLogger(EventExecutor.class);
    protected final Map<Class<? extends IEvent>, Collection<EventHandler<?>>> bindings = new HashMap();

    private <T extends IEvent> T executeEventInternal(T event, Predicate<EventHandler<?>> predicate) {
        Collection<EventHandler<?>> handlers = this.bindings.get(event.getClass());
        if (handlers != null) {
            List interestedHandlers = handlers.stream().filter(predicate).collect(Collectors.toList());
            ListIterator iterator = interestedHandlers.listIterator();
            while (iterator.hasNext()) {
                EventHandler performer = (EventHandler)iterator.next();
                performer.execute(event);
            }
        }
        return event;
    }

    @Override
    public <T extends IEvent> T executePostEvent(T event) {
        logger.debug((Object)("Execute pre event " + event));
        return this.executeEventInternal(event, eh -> eh.isAfter());
    }

    @Override
    public <T extends IEvent> T executePreEvent(T event) {
        logger.debug((Object)("Execute post event " + event));
        return this.executeEventInternal(event, eh -> !eh.isAfter());
    }

    @Override
    public <T extends IEvent> T executeEvent(T event, Runnable runInBetween) {
        this.executePreEvent(event);
        runInBetween.run();
        this.executePostEvent(event);
        return event;
    }

    public <T extends IEvent> T executeEvent(T event, Consumer<T> runInBetween) {
        this.executePreEvent(event);
        runInBetween.accept(event);
        this.executePostEvent(event);
        return event;
    }

    @Override
    public <T extends CancellableEvent> T executeCancellableEvent(T event, Runnable runInBetween) {
        this.executePreEvent(event);
        if (!event.isCancelled()) {
            runInBetween.run();
            this.executePostEvent(event);
        }
        return event;
    }

    public <T extends IEvent> void registerHandler(Class<T> realParam, EventHandler<T> handler) {
        if (!this.bindings.containsKey(realParam)) {
            this.bindings.put(realParam, this.createCollection());
        }
        Collection<EventHandler<?>> eventHandlersForEvent = this.bindings.get(realParam);
        eventHandlersForEvent.add(handler);
    }

    protected Collection<EventHandler<?>> createCollection() {
        return new ArrayList();
    }

    public void clearListeners() {
        this.bindings.clear();
    }

    public void removeHandler(EventHandler<?> listener) {
        for (Map.Entry<Class<IEvent>, Collection<EventHandler<?>>> ee : this.bindings.entrySet()) {
            Iterator<EventHandler<?>> it = ee.getValue().iterator();
            while (it.hasNext()) {
                EventHandler<?> curr = it.next();
                if (curr != listener) continue;
                it.remove();
            }
        }
    }

    public void removeListenersWithIdentifier(Object identifier) {
        for (Map.Entry<Class<IEvent>, Collection<EventHandler<?>>> ee : this.bindings.entrySet()) {
            ee.getValue().removeIf(eh -> eh.getIdentifier() == identifier);
        }
    }

    public <T extends IEvent> EventHandler<T> registerHandlerAfter(Object identifier, Class<T> realParam, Consumer<T> handler) {
        EventHandler<T> listener = new EventHandler<T>(identifier, handler, true);
        this.registerHandler(realParam, listener);
        return listener;
    }

    public <T extends IEvent> EventHandler<T> registerHandlerBefore(Object identifier, Class<T> realParam, Consumer<T> handler) {
        EventHandler<T> listener = new EventHandler<T>(identifier, handler, false);
        this.registerHandler(realParam, listener);
        return listener;
    }
}

