/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.cards;

import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.ECSSystem;
import com.cardshifter.modapi.cards.DrawCardEvent;
import java.util.function.Consumer;

public class LimitedHandSizeSystem
implements ECSSystem {
    private final int limit;
    private final Consumer<DrawCardEvent> actionWhenFull;

    public LimitedHandSizeSystem(int limit, Consumer<DrawCardEvent> actionWhenFull) {
        this.limit = limit;
        this.actionWhenFull = actionWhenFull;
    }

    @Override
    public void startGame(ECSGame game) {
        game.getEvents().registerHandlerBefore(this, DrawCardEvent.class, this::drawCard);
    }

    private void drawCard(DrawCardEvent event) {
        if (event.getToZone().size() >= this.limit) {
            event.setCancelled(true);
            this.actionWhenFull.accept(event);
        }
    }

    public String toString() {
        return "LimitedHandSizeSystem [limit=" + this.limit + ", actionWhenFull=" + this.actionWhenFull + "]";
    }
}

