/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.base;

import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.base.PlayerEliminatedEvent;
import java.util.ArrayList;
import java.util.Comparator;

public class PlayerComponent
extends Component {
    private final int index;
    private int resultPosition;
    private Boolean winnerDeclaration;
    private String name;

    public PlayerComponent(int index, String name) {
        this.index = index;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getIndex() {
        return this.index;
    }

    public void loseGame() {
        this.eliminate(false);
    }

    public void winGame() {
        this.eliminate(true);
    }

    private void eliminate(boolean winner) {
        ArrayList<Entity> players = new ArrayList<Entity>(this.getEntity().getGame().getEntitiesWithComponent(PlayerComponent.class));
        players.sort(Comparator.comparing(e -> e.getComponent(PlayerComponent.class).getIndex()));
        int playerResultPosition = winner ? 0 : players.size() + 1;
        boolean posTaken = false;
        block0: do {
            posTaken = false;
            playerResultPosition += winner ? -1 : 1;
            for (Entity pp : players) {
                PlayerComponent playerComponent = pp.getComponent(PlayerComponent.class);
                if (!playerComponent.isEliminated() || playerComponent.getResultPosition() != playerResultPosition) continue;
                posTaken = true;
                continue block0;
            }
        } while (posTaken);
        this.eliminate(winner, playerResultPosition);
    }

    private void eliminate(boolean winner, int resultPosition) {
        if (this.isEliminated()) {
            return;
        }
        this.executeCancellableEvent(new PlayerEliminatedEvent(this.getEntity(), winner, resultPosition), () -> {
            this.resultPosition = resultPosition;
            this.winnerDeclaration = winner;
        });
    }

    public int getResultPosition() {
        return this.resultPosition;
    }

    public boolean isEliminated() {
        return this.resultPosition != 0;
    }

    public Boolean getWinnerDeclaration() {
        return this.winnerDeclaration;
    }

    public String toString() {
        return "PlayerComponent [index=" + this.index + ", name=" + this.name + "]";
    }
}

