/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.modapi.actions;

import com.cardshifter.modapi.actions.ECSAction;
import com.cardshifter.modapi.actions.TargetableCheckEvent;
import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.events.EventExecutor;
import java.util.ArrayList;
import java.util.List;

public class TargetSet {
    private final List<Entity> chosenTargets;
    private final int min;
    private final int max;
    private final ECSAction action;

    public TargetSet(ECSAction action, int min, int max) {
        this.chosenTargets = new ArrayList<Entity>(min);
        this.action = action;
        this.min = min;
        this.max = max;
    }

    public boolean addTarget(Entity target) {
        if (!this.isTargetable(target)) {
            return false;
        }
        this.chosenTargets.add(target);
        return true;
    }

    private EventExecutor events() {
        return this.game().getEvents();
    }

    private ECSGame game() {
        return this.action.getOwner().getGame();
    }

    public boolean isTargetable(Entity target) {
        TargetableCheckEvent event = new TargetableCheckEvent(this.action, this, target);
        this.events().executePostEvent(event);
        return event.isAllowed();
    }

    public List<Entity> findPossibleTargets() {
        return this.game().findEntities(entity -> this.isTargetable((Entity)entity));
    }

    public int selectedTargets() {
        return this.chosenTargets.size();
    }

    public boolean hasEnoughTargets() {
        int targets = this.chosenTargets.size();
        return targets >= this.min && targets <= this.max;
    }

    public List<Entity> getChosenTargets() {
        return new ArrayList<Entity>(this.chosenTargets);
    }

    public void clearTargets() {
        this.chosenTargets.clear();
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }
}

