/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.cardshifter.ecs.usage.cw2;

import com.cardshifter.modapi.attributes.Attributes;
import com.cardshifter.modapi.attributes.ECSAttributeMap;
import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.resources.ECSResource;
import java.util.function.Consumer;
import net.zomis.cardshifter.ecs.effects.CostComponent;
import net.zomis.cardshifter.ecs.usage.CW2Game;
import net.zomis.cardshifter.ecs.usage.cw2.CW2Effects;

public class CrystalCards
implements Consumer<ECSGame> {
    private static final CW2Effects ef = new CW2Effects();

    @Override
    public void accept(ECSGame game) {
        this.addCard(game, "Mage", new Component[]{this.cost(CW2Game.Resources.CRYSTALS, 8), ef.myRes(CW2Game.Producers.WIZARDS, 1)});
        this.addCard(game, "Lightning", new Component[]{this.cost(CW2Game.Resources.CRYSTALS, 20), ef.damage(22)});
        this.addCard(game, "Quake", new Component[]{this.cost(CW2Game.Resources.CRYSTALS, 24), ef.damage(27)});
        this.addCard(game, "Pixies", new Component[]{this.cost(CW2Game.Resources.CRYSTALS, 18), ef.myRes(CW2Game.CWars2Res.CASTLE, 22)});
        this.addCard(game, "Magic Wall", new Component[]{this.cost(CW2Game.Resources.CRYSTALS, 14), ef.myRes(CW2Game.CWars2Res.WALL, 20)});
        for (CW2Game.Resources res : CW2Game.Resources.values()) {
            this.addCard(game, "Add " + (Object)((Object)res), new Component[]{this.cost(CW2Game.Resources.CRYSTALS, 5), ef.myRes(res, 8)});
            this.addCard(game, "Remove " + (Object)((Object)res), this.cost(CW2Game.Resources.CRYSTALS, 5), ef.oppRes(res, -8));
        }
        this.addCard(game, "All Crystals", this.cost(CW2Game.Resources.CRYSTALS, 1), ef.allFocus(CW2Game.Resources.CRYSTALS));
    }

    private void addCard(ECSGame game, String name, Component ... components) {
        Entity entity = game.newEntity();
        ECSAttributeMap.createFor((Entity)entity).set(Attributes.NAME, name);
        for (Component comp : components) {
            entity.addComponent(comp);
        }
    }

    private Component cost(ECSResource resource, int cost) {
        return new CostComponent(resource, cost);
    }
}

