/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.cardshifter.ecs.usage;

import com.cardshifter.modapi.actions.ActionComponent;
import com.cardshifter.modapi.actions.ECSAction;
import com.cardshifter.modapi.attributes.Attributes;
import com.cardshifter.modapi.attributes.ECSAttributeMap;
import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.ECSMod;
import com.cardshifter.modapi.base.ECSSystem;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.base.PlayerComponent;
import com.cardshifter.modapi.cards.BattlefieldComponent;
import com.cardshifter.modapi.cards.CardComponent;
import com.cardshifter.modapi.cards.DeckComponent;
import com.cardshifter.modapi.cards.DrawCardAtBeginningOfTurnSystem;
import com.cardshifter.modapi.cards.HandComponent;
import com.cardshifter.modapi.cards.LimitedHandSizeSystem;
import com.cardshifter.modapi.cards.RemoveDeadEntityFromZoneSystem;
import com.cardshifter.modapi.cards.ZoneComponent;
import com.cardshifter.modapi.phase.LimitedActionsPerTurnSystem;
import com.cardshifter.modapi.phase.PerformerMustBeCurrentPlayer;
import com.cardshifter.modapi.phase.Phase;
import com.cardshifter.modapi.phase.PhaseController;
import com.cardshifter.modapi.players.Players;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ECSResourceMap;
import com.cardshifter.modapi.resources.ResourceRetriever;
import java.util.Set;
import net.zomis.cardshifter.ecs.usage.LastPlayersStandingEndsGame;
import net.zomis.cardshifter.ecs.usage.PhrancisGame;

public class TestMod
implements ECSMod {
    public static final String END_TURN_ACTION = "End Turn";

    public void setupGame(ECSGame game) {
        PhaseController phaseController = new PhaseController();
        game.newEntity().addComponent((Component)phaseController);
        for (int i = 0; i < 2; ++i) {
            int playerIndex = i;
            Entity player = game.newEntity();
            PlayerComponent playerComponent = new PlayerComponent(i, "Player" + (i + 1));
            player.addComponent((Component)playerComponent);
            Phase playerPhase = new Phase(player, "Main");
            phaseController.addPhase(playerPhase);
            ActionComponent actions = new ActionComponent();
            player.addComponent((Component)actions);
            ECSAction endTurnAction = new ECSAction(player, END_TURN_ACTION, act -> phaseController.getCurrentPhase() == playerPhase, act -> phaseController.nextPhase());
            actions.addAction(endTurnAction);
            ECSResourceMap.createFor((Entity)player).set((ECSResource)PhrancisGame.PhrancisResources.HEALTH, 30).set((ECSResource)PhrancisGame.PhrancisResources.MAX_HEALTH, 30);
            DeckComponent deck = new DeckComponent(player);
            HandComponent hand = new HandComponent(player);
            BattlefieldComponent battlefield = new BattlefieldComponent(player);
            this.createCards((ZoneComponent)hand);
            this.createCards((ZoneComponent)deck);
            this.createCards((ZoneComponent)deck);
            this.createCards((ZoneComponent)deck);
            this.createCards((ZoneComponent)deck);
            player.addComponents(new Component[]{hand, deck, battlefield});
            deck.shuffle();
        }
        game.addSystem((ECSSystem)new LimitedHandSizeSystem(10, card -> card.getCardToDraw().destroy()));
        game.addSystem((ECSSystem)new DrawCardAtBeginningOfTurnSystem());
        game.addSystem((ECSSystem)new LimitedActionsPerTurnSystem(10, END_TURN_ACTION));
        game.addSystem((ECSSystem)new LastPlayersStandingEndsGame());
        game.addSystem((ECSSystem)new RemoveDeadEntityFromZoneSystem());
        game.addSystem((ECSSystem)new PerformerMustBeCurrentPlayer());
    }

    private void createCards(ZoneComponent hand) {
        for (int i = 0; i < 5; ++i) {
            Entity entity = hand.getOwner().getGame().newEntity();
            ECSResourceMap.createFor((Entity)entity).set((ECSResource)PhrancisGame.PhrancisResources.HEALTH, 3).set((ECSResource)PhrancisGame.PhrancisResources.MAX_HEALTH, 3);
            ECSAttributeMap.createFor((Entity)entity).set(Attributes.NAME, "Test");
            ActionComponent action = new ActionComponent();
            entity.addComponent((Component)action);
            action.addAction(this.moveAction("Field", entity, BattlefieldComponent.class, false));
            action.addAction(this.moveAction("Hand", entity, HandComponent.class, false));
            action.addAction(this.moveAction("Deck", entity, DeckComponent.class, false));
            action.addAction(this.moveAction("2-Field", entity, BattlefieldComponent.class, true));
            action.addAction(this.moveAction("2-Hand", entity, HandComponent.class, true));
            action.addAction(this.moveAction("2-Deck", entity, DeckComponent.class, true));
            action.addAction(this.damageAction(entity));
            hand.addOnBottom(entity);
        }
    }

    private ECSAction damageAction(Entity entity) {
        ResourceRetriever health = ResourceRetriever.forResource((ECSResource)PhrancisGame.PhrancisResources.HEALTH);
        return new ECSAction(entity, "Damage", act -> true, act -> {
            health.resFor(entity).change(-1);
            if (health.getFor(entity) == 0) {
                entity.destroy();
            }
        });
    }

    private ECSAction moveAction(String name, Entity entity, Class<? extends ZoneComponent> zone, boolean switchPlayer) {
        return new ECSAction(entity, name, act -> true, act -> {
            Entity player;
            CardComponent card = (CardComponent)act.getOwner().getComponent(CardComponent.class);
            Entity origPlayer = player = Players.findOwnerFor((Entity)act.getOwner());
            if (switchPlayer) {
                Set players = entity.getGame().getEntitiesWithComponent(PlayerComponent.class);
                player = players.stream().filter(pl -> pl != origPlayer).findAny().get();
            }
            card.moveToBottom((ZoneComponent)player.getComponent(zone));
        });
    }
}

