/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.cardshifter.ecs.usage;

import com.cardshifter.modapi.actions.ActionComponent;
import com.cardshifter.modapi.actions.ECSAction;
import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.ECSMod;
import com.cardshifter.modapi.base.ECSSystem;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.base.PlayerComponent;
import com.cardshifter.modapi.phase.LimitedActionsPerTurnSystem;
import com.cardshifter.modapi.phase.PerformerMustBeCurrentPlayer;
import com.cardshifter.modapi.phase.Phase;
import com.cardshifter.modapi.phase.PhaseController;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ECSResourceDefault;
import com.cardshifter.modapi.resources.ECSResourceMap;
import com.cardshifter.modapi.resources.GameOverIfNoHealth;
import com.cardshifter.modapi.resources.ResourceRetriever;

public class SimpleGame
implements ECSMod {
    private static final ECSResource HEALTH = new ECSResourceDefault("Health");
    private static final String END_TURN = "End Turn";

    public void setupGame(ECSGame game) {
        PhaseController phaseController = new PhaseController();
        game.newEntity().addComponent((Component)phaseController);
        for (int i = 1; i <= 2; ++i) {
            PlayerComponent playerComponent = new PlayerComponent(i - 1, "Player" + i);
            Entity player = game.newEntity().addComponent((Component)playerComponent);
            Phase playerPhase = new Phase(player, "Main");
            phaseController.addPhase(playerPhase);
            ActionComponent actions = new ActionComponent();
            player.addComponent((Component)actions);
            ResourceRetriever health = ResourceRetriever.forResource((ECSResource)HEALTH);
            actions.addAction(new ECSAction(player, END_TURN, act -> phaseController.getCurrentPhase() == playerPhase, act -> phaseController.nextPhase()));
            actions.addAction(new ECSAction(player, "Damage me", act -> phaseController.getCurrentPhase() == playerPhase, act -> health.resFor(player).change(-2)));
            actions.addAction(new ECSAction(player, "Heal", act -> phaseController.getCurrentPhase() == playerPhase, act -> health.resFor(player).change(1)));
            ECSResourceMap.createFor((Entity)player).set(HEALTH, 10);
        }
        game.addSystem((ECSSystem)new LimitedActionsPerTurnSystem(5, END_TURN));
        game.addSystem((ECSSystem)new GameOverIfNoHealth(HEALTH));
        game.addSystem((ECSSystem)new PerformerMustBeCurrentPlayer());
    }
}

