/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.cardshifter.ecs.usage;

import com.cardshifter.modapi.actions.ActionAllowedCheckEvent;
import com.cardshifter.modapi.actions.ActionPerformEvent;
import com.cardshifter.modapi.actions.SpecificActionSystem;
import com.cardshifter.modapi.base.ComponentRetriever;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.base.Retriever;
import com.cardshifter.modapi.cards.BattlefieldComponent;
import com.cardshifter.modapi.cards.CardComponent;
import com.cardshifter.modapi.cards.Cards;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ResourceRetriever;
import java.util.function.Predicate;

public class ScrapSystem
extends SpecificActionSystem {
    private final ResourceRetriever resource;
    private final Predicate<Entity> predicate;
    @Retriever
    private ComponentRetriever<CardComponent> card;

    public ScrapSystem(ECSResource resource, Predicate<Entity> predicate) {
        super("Scrap");
        this.resource = ResourceRetriever.forResource((ECSResource)resource);
        this.predicate = predicate;
    }

    protected void isAllowed(ActionAllowedCheckEvent event) {
        if (!Cards.isOwnedByCurrentPlayer((Entity)event.getEntity())) {
            event.setAllowed(false);
        }
        if (!Cards.isOnZone((Entity)event.getEntity(), BattlefieldComponent.class)) {
            event.setAllowed(false);
        }
        if (this.resource.getOrDefault(event.getEntity(), 0) <= 0) {
            event.setAllowed(false);
        }
        if (!this.predicate.test(event.getEntity())) {
            event.setAllowed(false);
        }
    }

    protected void onPerform(ActionPerformEvent event) {
        this.forceScrap(event.getEntity());
    }

    public void forceScrap(Entity entity) {
        Entity cardOwner = Cards.getOwner((Entity)entity);
        int scrapValue = this.resource.getOrDefault(entity, 0);
        this.resource.resFor(cardOwner).change(scrapValue);
        entity.destroy();
    }
}

