/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.cardshifter.ecs.usage;

import com.cardshifter.modapi.base.ECSSystem;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.base.PlayerComponent;
import com.cardshifter.modapi.cards.DrawStartCards;
import com.cardshifter.modapi.cards.ZoneComponent;
import com.cardshifter.modapi.phase.PhaseEndEvent;
import com.cardshifter.modapi.players.Players;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ResourceRetriever;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import net.zomis.cardshifter.ecs.effects.Effects;
import net.zomis.cardshifter.ecs.effects.FilterComponent;
import net.zomis.cardshifter.ecs.effects.Filters;
import net.zomis.cardshifter.ecs.usage.EntityCannotUseSystem;
import net.zomis.cardshifter.ecs.usage.PhrancisGame;
import net.zomis.cardshifter.ecs.usage.PhrancisGameNewAttackSystem;
import net.zomis.cardshifter.ecs.usage.UntilEndOfOwnerTurnSystem;

public class PhrancisGameWithSpells
extends PhrancisGameNewAttackSystem {
    @Override
    public void addCards(ZoneComponent zone) {
        super.addCards(zone);
        Filters filters = new Filters();
        Effects effects = new Effects();
        IntUnaryOperator attackLimit = i -> Math.max(i, 0);
        IntUnaryOperator healthLimit = i -> Math.max(i, 1);
        Supplier<FilterComponent> targetSupplier = () -> new FilterComponent(filters.isCreature().and(filters.isCreatureOnBattlefield()));
        this.createTargetSpell("", zone, 4, 2, effects.giveTarget(e -> new UntilEndOfOwnerTurnSystem((Entity)e, (ECSSystem)new EntityCannotUseSystem((Entity)e, "Attack"))), new FilterComponent(new Filters().isCreatureOnBattlefield()));
        this.createTargetSpell("", zone, 4, 4, effects.giveTarget(effects.triggerSystem(PhaseEndEvent.class, (me, event) -> Players.findOwnerFor((Entity)me) == event.getOldPhase().getOwner(), (me, event) -> DrawStartCards.drawCard((Entity)event.getOldPhase().getOwner()))), targetSupplier.get());
        ResourceRetriever health = ResourceRetriever.forResource((ECSResource)PhrancisGame.PhrancisResources.HEALTH);
        this.createSpell("Heal All Players", zone, 0, 0, effects.forEach((src, dst) -> dst.hasComponent(PlayerComponent.class), (src, dst) -> health.resFor(dst).change(10)));
        this.createTargetSpell("Decrease Health", zone, 2, 2, effects.giveTarget((ECSResource)PhrancisGame.PhrancisResources.HEALTH, -2, healthLimit), targetSupplier.get());
        this.createTargetSpell("Decrease Attack", zone, 2, 2, effects.giveTarget((ECSResource)PhrancisGame.PhrancisResources.ATTACK, -2, attackLimit), targetSupplier.get());
    }
}

