/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.cardshifter.ecs.usage;

import com.cardshifter.api.config.DeckConfig;
import com.cardshifter.core.cardloader.CardLoadingException;
import com.cardshifter.core.cardloader.SimpleCardLoader;
import com.cardshifter.modapi.actions.ActionComponent;
import com.cardshifter.modapi.actions.ECSAction;
import com.cardshifter.modapi.actions.UseCostSystem;
import com.cardshifter.modapi.actions.attack.AttackDamageYGO;
import com.cardshifter.modapi.actions.attack.AttackOnBattlefield;
import com.cardshifter.modapi.actions.attack.AttackSickness;
import com.cardshifter.modapi.actions.attack.AttackTargetMinionsFirstThenPlayer;
import com.cardshifter.modapi.actions.attack.TrampleSystem;
import com.cardshifter.modapi.actions.enchant.EnchantPerform;
import com.cardshifter.modapi.actions.enchant.EnchantTargetCreatureTypes;
import com.cardshifter.modapi.attributes.AttributeRetriever;
import com.cardshifter.modapi.attributes.Attributes;
import com.cardshifter.modapi.attributes.ECSAttribute;
import com.cardshifter.modapi.attributes.ECSAttributeMap;
import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.CreatureTypeComponent;
import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.ECSMod;
import com.cardshifter.modapi.base.ECSSystem;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.base.ModHelper;
import com.cardshifter.modapi.base.PlayerComponent;
import com.cardshifter.modapi.cards.BattlefieldComponent;
import com.cardshifter.modapi.cards.CardComponent;
import com.cardshifter.modapi.cards.Cards;
import com.cardshifter.modapi.cards.DamageConstantWhenOutOfCardsSystem;
import com.cardshifter.modapi.cards.DeckComponent;
import com.cardshifter.modapi.cards.DrawCardAtBeginningOfTurnSystem;
import com.cardshifter.modapi.cards.DrawStartCards;
import com.cardshifter.modapi.cards.HandComponent;
import com.cardshifter.modapi.cards.LimitedHandSizeSystem;
import com.cardshifter.modapi.cards.MulliganSingleCards;
import com.cardshifter.modapi.cards.PlayEntersBattlefieldSystem;
import com.cardshifter.modapi.cards.PlayFromHandSystem;
import com.cardshifter.modapi.cards.RemoveDeadEntityFromZoneSystem;
import com.cardshifter.modapi.cards.ZoneComponent;
import com.cardshifter.modapi.phase.GainResourceSystem;
import com.cardshifter.modapi.phase.PerformerMustBeCurrentPlayer;
import com.cardshifter.modapi.phase.Phase;
import com.cardshifter.modapi.phase.PhaseController;
import com.cardshifter.modapi.phase.PhaseEndEvent;
import com.cardshifter.modapi.phase.RestoreResourcesSystem;
import com.cardshifter.modapi.players.Players;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ECSResourceMap;
import com.cardshifter.modapi.resources.GameOverIfNoHealth;
import com.cardshifter.modapi.resources.ResourceRetriever;
import com.cardshifter.modapi.resources.RestoreResourcesToSystem;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.zomis.cardshifter.ecs.config.ConfigComponent;
import net.zomis.cardshifter.ecs.config.DeckConfigFactory;
import net.zomis.cardshifter.ecs.effects.EffectActionSystem;
import net.zomis.cardshifter.ecs.effects.EffectComponent;
import net.zomis.cardshifter.ecs.effects.EffectTargetFilterSystem;
import net.zomis.cardshifter.ecs.effects.Effects;
import net.zomis.cardshifter.ecs.effects.FilterComponent;
import net.zomis.cardshifter.ecs.effects.Filters;
import net.zomis.cardshifter.ecs.effects.TargetFilter;
import net.zomis.cardshifter.ecs.usage.ApplyAfterAttack;
import net.zomis.cardshifter.ecs.usage.DenyActionForNames;
import net.zomis.cardshifter.ecs.usage.DestroyAfterUseSystem;
import net.zomis.cardshifter.ecs.usage.LastPlayersStandingEndsGame;
import net.zomis.cardshifter.ecs.usage.ScrapSystem;

public class PhrancisGame
implements ECSMod {
    public static final String PLAY_ACTION = "Play";
    public static final String ENCHANT_ACTION = "Enchant";
    public static final String ATTACK_ACTION = "Attack";
    public static final String SCRAP_ACTION = "Scrap";
    public static final String END_TURN_ACTION = "End Turn";
    public static final String USE_ACTION = "Use";
    private static final AttributeRetriever name = AttributeRetriever.forAttribute((ECSAttribute)Attributes.NAME);
    private final Set<String> noAttackNames = new HashSet<String>();
    private Consumer<Entity> noAttack = e -> this.noAttackNames.add(name.getFor(e));
    private Entity neutral;
    private final ResourceRetriever health = ResourceRetriever.forResource((ECSResource)PhrancisResources.HEALTH);
    private final ResourceRetriever healthMax = ResourceRetriever.forResource((ECSResource)PhrancisResources.MAX_HEALTH);
    private final BiFunction<Entity, Integer, Integer> restoreHealth = (e, value) -> Math.max(Math.min(this.healthMax.getFor(e) - this.health.getFor(e), value), 0);
    private Consumer<Entity> giveRush = e -> {
        Effects effects = new Effects();
        e.addComponent(effects.described("Give Rush", effects.giveTarget((ECSResource)PhrancisResources.SICKNESS, 0, i -> 0)));
    };
    private Consumer<Entity> giveRanged = e -> {
        Effects effects = new Effects();
        e.addComponent(effects.described("Give Ranged", effects.giveTarget((ECSResource)PhrancisResources.DENY_COUNTERATTACK, 1)));
    };
    private final Consumer<Entity> enchantment = e -> e.addComponent((Component)new ActionComponent().addAction(PhrancisGame.enchantAction(e)));

    public void declareConfiguration(ECSGame game) {
        this.neutral = game.newEntity();
        ZoneComponent zone = new ZoneComponent(this.neutral, "Cards");
        this.neutral.addComponent((Component)zone);
        this.addCards(zone);
        int maxCardsPerType = 3;
        int minSize = 30;
        int maxSize = 30;
        for (int i = 0; i < 2; ++i) {
            Entity entity = game.newEntity();
            PlayerComponent playerComponent = new PlayerComponent(i, "Player" + (i + 1));
            entity.addComponent((Component)playerComponent);
            DeckConfig config = DeckConfigFactory.create((int)minSize, (int)maxSize, (List)zone.getCards(), (int)maxCardsPerType);
            entity.addComponent((Component)new ConfigComponent().addConfig("Deck", (Object)config));
        }
    }

    private Consumer<Entity> summon(int count, String creatureName) {
        Effects effects = new Effects();
        return en -> en.addComponent(effects.described("Summon " + count + " " + creatureName, effects.toSelf(e -> {
            Entity entity = Players.findOwnerFor((Entity)e);
            ZoneComponent field = (ZoneComponent)entity.getComponent(BattlefieldComponent.class);
            Entity summon = ((ZoneComponent)this.neutral.getComponent(ZoneComponent.class)).getCards().stream().filter(card -> name.getFor(card).equals(creatureName)).findAny().get();
            for (int i = 0; i < count; ++i) {
                field.addOnBottom(summon.copy());
            }
        })));
    }

    private Consumer<Entity> healTurnEnd(int heal) {
        Effects effects = new Effects();
        return en -> en.addComponent(effects.described("Heal 1 at end of turn", effects.giveSelf(effects.triggerSystem(PhaseEndEvent.class, (me, event) -> Players.findOwnerFor((Entity)me) == event.getOldPhase().getOwner(), (me, event) -> Players.findOwnerFor((Entity)me).apply(e -> this.health.resFor(e).change(this.restoreHealth.apply((Entity)e, heal).intValue()))))));
    }

    public Consumer<Entity> damageToRandomOpponentAtEndOfTurn(int damage) {
        Effects effects = new Effects();
        Filters filters = new Filters();
        return e -> e.addComponent(effects.described("Deal " + damage + " damage to random enemy at end of turn", effects.giveSelf(effects.atEndOfTurn(effects.toRandom(TargetFilter.or((TargetFilter[])new TargetFilter[]{filters.enemy().and(filters.isCreatureOnBattlefield()), filters.enemy().and(filters.isPlayer())}), (src, target) -> effects.modify(target, (ECSResource)PhrancisResources.HEALTH, -damage).accept(target))))));
    }

    private Consumer<Entity> damageTurnEnd(int damage) {
        Effects effects = new Effects();
        return en -> en.addComponent(effects.described("Take " + damage + " damage at end of turn", effects.giveSelf(effects.triggerSystem(PhaseEndEvent.class, (me, event) -> Players.findOwnerFor((Entity)me) == event.getOldPhase().getOwner(), (me, event) -> Players.findOwnerFor((Entity)me).apply(e -> this.health.resFor(e).change(Math.min(0, -damage)))))));
    }

    public void addCards(ZoneComponent zone) {
        ResourceRetriever rangedResource = ResourceRetriever.forResource((ECSResource)PhrancisResources.DENY_COUNTERATTACK);
        Consumer<Entity> ranged = e -> rangedResource.resFor(e).set(1);
        Path cardFile = ModHelper.getPath((ECSMod)this, (String)"phrancis-cards.cards");
        ECSAttribute[] defaultAttributes = new ECSAttribute[]{Attributes.NAME, Attributes.FLAVOR};
        try {
            Collection<Entity> cards = new SimpleCardLoader().loadCards(cardFile, zone.getComponentEntity().getGame(), (ECSMod)this, (ECSResource[])PhrancisResources.values(), defaultAttributes);
            cards.forEach(c -> zone.addOnBottom(c));
        }
        catch (CardLoadingException e2) {
            throw new RuntimeException(e2);
        }
        ECSGame game = zone.getComponentEntity().getGame();
        game.addSystem((ECSSystem)new DenyActionForNames(ATTACK_ACTION, this.noAttackNames));
    }

    public Entity createTargetSpell(String name, ZoneComponent zone, int manaCost, int scrapCost, EffectComponent effect, FilterComponent filter) {
        return this.createSpellWithTargets(name, 1, zone, manaCost, scrapCost, new Component[]{effect, filter});
    }

    public Entity createSpell(String name, ZoneComponent zone, int manaCost, int scrapCost, EffectComponent effect) {
        return this.createSpellWithTargets(name, 0, zone, manaCost, scrapCost, new Component[]{effect});
    }

    private Entity createSpellWithTargets(String name, int targets, ZoneComponent zone, int manaCost, int scrapCost, Component ... components) {
        Entity entity = zone.getOwner().getGame().newEntity();
        ECSResourceMap.createFor((Entity)entity).set((ECSResource)PhrancisResources.SCRAP_COST, scrapCost).set((ECSResource)PhrancisResources.MANA_COST, manaCost);
        ECSAttributeMap.createFor((Entity)entity).set(Attributes.NAME, name);
        entity.addComponent((Component)new ActionComponent().addAction(this.spellAction(entity, targets)));
        entity.addComponents(components);
        zone.addOnBottom(entity);
        return entity;
    }

    private ECSAction spellAction(Entity entity, int targets) {
        ECSAction action = new ECSAction(entity, USE_ACTION, act -> true, act -> {});
        if (targets > 0) {
            action.addTargetSet(targets, targets);
        }
        return action;
    }

    public void setupGame(ECSGame game) {
        this.playerSetup(game);
        this.systemSetup(game);
    }

    public void systemSetup(ECSGame game) {
        ResourceRetriever manaMaxResource = ResourceRetriever.forResource((ECSResource)PhrancisResources.MANA_MAX);
        ResourceRetriever manaCostResource = ResourceRetriever.forResource((ECSResource)PhrancisResources.MANA_COST);
        UnaryOperator owningPlayerPays = entity -> ((CardComponent)entity.getComponent(CardComponent.class)).getOwner();
        game.addSystem((ECSSystem)new GainResourceSystem((ECSResource)PhrancisResources.MANA_MAX, entity -> Math.min(1, Math.abs(manaMaxResource.getFor(entity) - 10))));
        game.addSystem((ECSSystem)new RestoreResourcesSystem((ECSResource)PhrancisResources.MANA, entity -> manaMaxResource.getFor(entity)));
        game.addSystem((ECSSystem)new PlayFromHandSystem(PLAY_ACTION));
        game.addSystem((ECSSystem)new PlayEntersBattlefieldSystem(PLAY_ACTION));
        game.addSystem((ECSSystem)new UseCostSystem(PLAY_ACTION, (ECSResource)PhrancisResources.MANA, arg_0 -> ((ResourceRetriever)manaCostResource).getFor(arg_0), owningPlayerPays));
        ResourceRetriever scrapCostResource = ResourceRetriever.forResource((ECSResource)PhrancisResources.SCRAP_COST);
        ResourceRetriever attackAvailable = ResourceRetriever.forResource((ECSResource)PhrancisResources.ATTACK_AVAILABLE);
        ResourceRetriever sickness = ResourceRetriever.forResource((ECSResource)PhrancisResources.SICKNESS);
        game.addSystem((ECSSystem)new ScrapSystem(PhrancisResources.SCRAP, e -> attackAvailable.getOrDefault(e, 0) > 0 && sickness.getOrDefault(e, 1) == 0));
        game.addSystem((ECSSystem)new UseCostSystem(USE_ACTION, (ECSResource)PhrancisResources.MANA, arg_0 -> ((ResourceRetriever)manaCostResource).getFor(arg_0), owningPlayerPays));
        game.addSystem((ECSSystem)new UseCostSystem(USE_ACTION, (ECSResource)PhrancisResources.SCRAP, arg_0 -> ((ResourceRetriever)scrapCostResource).getFor(arg_0), owningPlayerPays));
        game.addSystem((ECSSystem)new PlayFromHandSystem(USE_ACTION));
        game.addSystem((ECSSystem)new EffectActionSystem(USE_ACTION));
        game.addSystem((ECSSystem)new EffectActionSystem(ENCHANT_ACTION));
        game.addSystem((ECSSystem)new EffectActionSystem(PLAY_ACTION));
        game.addSystem((ECSSystem)new EffectTargetFilterSystem(USE_ACTION));
        game.addSystem((ECSSystem)new DestroyAfterUseSystem(USE_ACTION));
        ResourceRetriever allowCounterAttackRes = ResourceRetriever.forResource((ECSResource)PhrancisResources.DENY_COUNTERATTACK);
        BiPredicate<Entity, Entity> allowCounterAttack = (attacker, defender) -> allowCounterAttackRes.getOrDefault(attacker, 0) == 0;
        game.addSystem((ECSSystem)new AttackOnBattlefield());
        game.addSystem((ECSSystem)new AttackSickness((ECSResource)PhrancisResources.SICKNESS));
        game.addSystem((ECSSystem)new AttackTargetMinionsFirstThenPlayer((ECSResource)PhrancisResources.TAUNT));
        game.addSystem((ECSSystem)new AttackDamageYGO((ECSResource)PhrancisResources.ATTACK, (ECSResource)PhrancisResources.HEALTH, allowCounterAttack));
        game.addSystem((ECSSystem)new UseCostSystem(ATTACK_ACTION, (ECSResource)PhrancisResources.ATTACK_AVAILABLE, entity -> 1, entity -> entity));
        game.addSystem((ECSSystem)new RestoreResourcesToSystem(entity -> entity.hasComponent(CreatureTypeComponent.class) && Cards.isOnZone((Entity)entity, BattlefieldComponent.class) && Cards.isOwnedByCurrentPlayer((Entity)entity), (ECSResource)PhrancisResources.ATTACK_AVAILABLE, entity -> 1));
        game.addSystem((ECSSystem)new RestoreResourcesToSystem(entity -> entity.hasComponent(CreatureTypeComponent.class) && Cards.isOnZone((Entity)entity, BattlefieldComponent.class) && Cards.isOwnedByCurrentPlayer((Entity)entity), (ECSResource)PhrancisResources.SICKNESS, entity -> Math.max(0, sickness.getFor(entity) - 1)));
        game.addSystem((ECSSystem)new TrampleSystem((ECSResource)PhrancisResources.HEALTH));
        game.addSystem((ECSSystem)new ApplyAfterAttack(e -> allowCounterAttackRes.getFor(e) > 0, e -> sickness.resFor(e).set(2)));
        game.addSystem((ECSSystem)new PlayFromHandSystem(ENCHANT_ACTION));
        game.addSystem((ECSSystem)new UseCostSystem(ENCHANT_ACTION, (ECSResource)PhrancisResources.SCRAP, arg_0 -> ((ResourceRetriever)scrapCostResource).getFor(arg_0), owningPlayerPays));
        game.addSystem((ECSSystem)new EnchantTargetCreatureTypes(new String[]{"Bio"}));
        game.addSystem((ECSSystem)new EnchantPerform(new ECSResource[]{PhrancisResources.ATTACK, PhrancisResources.HEALTH, PhrancisResources.MAX_HEALTH}));
        game.addSystem((ECSSystem)new DrawStartCards(5));
        game.addSystem((ECSSystem)new MulliganSingleCards(game));
        game.addSystem((ECSSystem)new DrawCardAtBeginningOfTurnSystem());
        game.addSystem((ECSSystem)new DamageConstantWhenOutOfCardsSystem((ECSResource)PhrancisResources.HEALTH, 1));
        game.addSystem((ECSSystem)new LimitedHandSizeSystem(10, card -> card.getCardToDraw().destroy()));
        game.addSystem((ECSSystem)new GameOverIfNoHealth((ECSResource)PhrancisResources.HEALTH));
        game.addSystem((ECSSystem)new LastPlayersStandingEndsGame());
        game.addSystem((ECSSystem)new RemoveDeadEntityFromZoneSystem());
        game.addSystem((ECSSystem)new PerformerMustBeCurrentPlayer());
    }

    public void playerSetup(ECSGame game) {
        PhaseController phaseController = new PhaseController();
        game.newEntity().addComponent((Component)phaseController);
        for (int i = 0; i < 2; ++i) {
            int playerIndex = i;
            Entity player = (Entity)game.findEntities(e -> e.hasComponent(PlayerComponent.class) && ((PlayerComponent)e.getComponent(PlayerComponent.class)).getIndex() == playerIndex).get(0);
            Phase playerPhase = new Phase(player, "Main");
            phaseController.addPhase(playerPhase);
            ActionComponent actions = new ActionComponent();
            player.addComponent((Component)actions);
            ECSAction endTurnAction = new ECSAction(player, END_TURN_ACTION, act -> phaseController.getCurrentPhase() == playerPhase, act -> phaseController.nextPhase());
            actions.addAction(endTurnAction);
            ECSResourceMap.createFor((Entity)player).set((ECSResource)PhrancisResources.HEALTH, 30).set((ECSResource)PhrancisResources.MAX_HEALTH, 30).set((ECSResource)PhrancisResources.MANA, 0).set((ECSResource)PhrancisResources.SCRAP, 0);
            DeckComponent deck = new DeckComponent(player);
            HandComponent hand = new HandComponent(player);
            BattlefieldComponent battlefield = new BattlefieldComponent(player);
            player.addComponents(new Component[]{hand, deck, battlefield});
            ConfigComponent config = (ConfigComponent)player.getComponent(ConfigComponent.class);
            DeckConfig deckConf = (DeckConfig)config.getConfig(DeckConfig.class);
            if (deckConf.total() < deckConf.getMinSize()) {
                deckConf.generateRandom();
            }
            this.setupDeck((ZoneComponent)deck, deckConf);
            deck.shuffle();
        }
    }

    private void setupDeck(ZoneComponent deck, DeckConfig deckConf) {
        ECSGame game = deck.getOwner().getGame();
        for (Map.Entry chosen : deckConf.getChosen().entrySet()) {
            int entityId = (Integer)chosen.getKey();
            int count = (Integer)chosen.getValue();
            for (int i = 0; i < count; ++i) {
                Entity existing = game.getEntity(entityId);
                Entity copy = existing.copy();
                deck.addOnBottom(copy);
            }
        }
    }

    public Entity createEnchantment(ZoneComponent deck, int strength, int health, int cost, String name) {
        Entity entity = deck.getOwner().getGame().newEntity();
        ECSResourceMap.createFor((Entity)entity).set((ECSResource)PhrancisResources.HEALTH, health).set((ECSResource)PhrancisResources.MAX_HEALTH, health).set((ECSResource)PhrancisResources.SCRAP_COST, cost).set((ECSResource)PhrancisResources.ATTACK, strength);
        ECSAttributeMap.createFor((Entity)entity).set(Attributes.NAME, name);
        this.enchantment.accept(entity);
        deck.addOnBottom(entity);
        return entity;
    }

    public Consumer<Entity> creature(String creatureType) {
        return entity -> {
            ActionComponent actions = new ActionComponent();
            entity.addComponent((Component)actions);
            actions.addAction(PhrancisGame.playAction(entity));
            actions.addAction(PhrancisGame.attackAction(entity));
            actions.addAction(PhrancisGame.scrapAction(entity));
            entity.addComponent((Component)new CreatureTypeComponent(creatureType));
            ECSResourceMap map = ECSResourceMap.createOrGetFor((Entity)entity);
            map.set((ECSResource)PhrancisResources.SICKNESS, 1);
            map.set((ECSResource)PhrancisResources.TAUNT, 1);
            map.set((ECSResource)PhrancisResources.ATTACK_AVAILABLE, 1);
        };
    }

    private Consumer<Entity> health(int health) {
        return e -> {
            ECSResourceMap map = ECSResourceMap.createOrGetFor((Entity)e);
            map.set((ECSResource)PhrancisResources.HEALTH, health);
            map.set((ECSResource)PhrancisResources.MAX_HEALTH, health);
        };
    }

    public static ECSAction enchantAction(Entity entity) {
        return new ECSAction(entity, ENCHANT_ACTION, act -> true, act -> {}).addTargetSet(1, 1);
    }

    public Entity createCreature(int cost, ZoneComponent deck, int strength, int health, String creatureType, int scrapValue) {
        return this.createCreature(cost, deck, strength, health, creatureType, scrapValue, "Untitled");
    }

    public Entity createCreature(int cost, ZoneComponent deck, int strength, int health, String creatureType, int scrapValue, String name) {
        Entity entity = deck.getOwner().getGame().newEntity();
        ECSResourceMap.createFor((Entity)entity).set((ECSResource)PhrancisResources.HEALTH, health).set((ECSResource)PhrancisResources.MAX_HEALTH, health).set((ECSResource)PhrancisResources.ATTACK, strength).set((ECSResource)PhrancisResources.SCRAP, scrapValue).set((ECSResource)PhrancisResources.MANA_COST, cost).set((ECSResource)PhrancisResources.SICKNESS, 1).set((ECSResource)PhrancisResources.TAUNT, 1).set((ECSResource)PhrancisResources.ATTACK_AVAILABLE, 1);
        ECSAttributeMap.createFor((Entity)entity).set(Attributes.NAME, name);
        this.creature(creatureType).accept(entity);
        deck.addOnBottom(entity);
        return entity;
    }

    public static ECSAction attackAction(Entity entity) {
        return new ECSAction(entity, ATTACK_ACTION, act -> true, act -> {}).addTargetSet(1, 1);
    }

    public static ECSAction scrapAction(Entity entity) {
        return new ECSAction(entity, SCRAP_ACTION, act -> true, act -> {});
    }

    public static ECSAction playAction(Entity entity) {
        return new ECSAction(entity, PLAY_ACTION, act -> true, act -> {});
    }

    public static enum PhrancisResources implements ECSResource
    {
        MAX_HEALTH,
        TAUNT,
        DENY_COUNTERATTACK,
        HEALTH,
        MANA,
        MANA_MAX,
        SCRAP,
        ATTACK,
        MANA_COST,
        SCRAP_COST,
        SICKNESS,
        ATTACK_AVAILABLE;

    }
}

