/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.cardshifter.ecs.usage;

import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.ECSSystem;
import com.cardshifter.modapi.base.PlayerComponent;
import com.cardshifter.modapi.base.PlayerEliminatedEvent;

public class LastPlayersStandingEndsGame
implements ECSSystem {
    private final int playersRemainingToEnd;

    public LastPlayersStandingEndsGame() {
        this(1);
    }

    public LastPlayersStandingEndsGame(int playersRemainingToEnd) {
        this.playersRemainingToEnd = playersRemainingToEnd;
    }

    public void startGame(ECSGame game) {
        game.getEvents().registerHandlerAfter((Object)this, PlayerEliminatedEvent.class, this::onPlayerEliminated);
    }

    private void onPlayerEliminated(PlayerEliminatedEvent event) {
        long numAlive = event.getEntity().getGame().getEntitiesWithComponent(PlayerComponent.class).stream().map(e -> (PlayerComponent)e.getComponent(PlayerComponent.class)).filter(pl -> !pl.isEliminated()).count();
        if (numAlive <= (long)this.playersRemainingToEnd) {
            event.getEntity().getGame().endGame();
        }
    }
}

