/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.cardshifter.ecs.usage;

import com.cardshifter.modapi.actions.ActionComponent;
import com.cardshifter.modapi.actions.ECSAction;
import com.cardshifter.modapi.actions.UseCostSystem;
import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.ECSMod;
import com.cardshifter.modapi.base.ECSSystem;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.base.PlayerComponent;
import com.cardshifter.modapi.cards.CardComponent;
import com.cardshifter.modapi.cards.DeckComponent;
import com.cardshifter.modapi.cards.DrawStartCards;
import com.cardshifter.modapi.cards.HandComponent;
import com.cardshifter.modapi.cards.PlayFromHandSystem;
import com.cardshifter.modapi.cards.RemoveDeadEntityFromZoneSystem;
import com.cardshifter.modapi.phase.GainResourceSystem;
import com.cardshifter.modapi.phase.LimitedActionsPerTurnSystem;
import com.cardshifter.modapi.phase.Phase;
import com.cardshifter.modapi.phase.PhaseController;
import com.cardshifter.modapi.resources.ECSResource;
import com.cardshifter.modapi.resources.ECSResourceMap;
import com.cardshifter.modapi.resources.GameOverIfNoHealth;
import com.cardshifter.modapi.resources.ResourceRetriever;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.zomis.cardshifter.ecs.effects.EffectActionSystem;
import net.zomis.cardshifter.ecs.usage.CannotUseUnknownCardsSystem;
import net.zomis.cardshifter.ecs.usage.cw2.CrystalCards;
import net.zomis.cardshifter.ecs.usage.cw2.DiscardExchangeSystem;

public class CW2Game
implements ECSMod {
    private static final String PLAY_ACTION = "Play";
    private static final String DISCARD_ACTION = "Discard";

    public void setupGame(ECSGame game) {
        PhaseController phaseController = new PhaseController();
        game.newEntity().addComponent((Component)phaseController);
        for (int i = 1; i <= 2; ++i) {
            PlayerComponent playerComponent = new PlayerComponent(i - 1, "Player" + i);
            Entity player = game.newEntity().addComponent((Component)playerComponent);
            Phase playerPhase = new Phase(player, "Main");
            phaseController.addPhase(playerPhase);
            ActionComponent actions = new ActionComponent();
            player.addComponent((Component)actions);
            actions.addAction(new ECSAction(player, DISCARD_ACTION, act -> phaseController.getCurrentPhase() == playerPhase, act -> phaseController.nextPhase()).addTargetSet(1, 3));
            ECSResourceMap res = ECSResourceMap.createFor((Entity)player).set((ECSResource)CWars2Res.CASTLE, 25).set((ECSResource)CWars2Res.WALL, 15);
            for (Producers prod : Producers.values()) {
                res.set((ECSResource)prod, 2);
                res.set((ECSResource)prod.getResource(), 8);
            }
            DeckComponent deck = new DeckComponent(player);
            HandComponent hand = new HandComponent(player);
            player.addComponents(new Component[]{hand, deck});
        }
        List<Consumer> cardsets = Arrays.asList(new CrystalCards());
        cardsets.forEach(set -> set.accept(game));
        UnaryOperator owningPlayerPays = entity -> ((CardComponent)entity.getComponent(CardComponent.class)).getOwner();
        for (Producers prod : Producers.values()) {
            ResourceRetriever prodRes = ResourceRetriever.forResource((ECSResource)prod);
            ResourceRetriever res = ResourceRetriever.forResource((ECSResource)prod.getResource());
            game.addSystem((ECSSystem)new GainResourceSystem((ECSResource)prod.getResource(), entity -> prodRes.getFor(entity)));
            game.addSystem((ECSSystem)new UseCostSystem(PLAY_ACTION, (ECSResource)prod.getResource(), e -> res.getFor(e), owningPlayerPays));
        }
        game.addSystem((ECSSystem)new PlayFromHandSystem(PLAY_ACTION));
        game.addSystem((ECSSystem)new EffectActionSystem(PLAY_ACTION));
        game.addSystem((ECSSystem)new DiscardExchangeSystem(DISCARD_ACTION));
        game.addSystem((ECSSystem)new LimitedActionsPerTurnSystem(1, null));
        game.addSystem((ECSSystem)new DrawStartCards(8));
        game.addSystem((ECSSystem)new GameOverIfNoHealth((ECSResource)CWars2Res.CASTLE));
        game.addSystem((ECSSystem)new RemoveDeadEntityFromZoneSystem());
        game.addSystem((ECSSystem)new CannotUseUnknownCardsSystem());
    }

    public static enum Producers implements ECSResource
    {
        BUILDERS,
        RECRUITS,
        WIZARDS;


        public Resources getResource() {
            return Resources.values()[this.ordinal()];
        }
    }

    public static enum Resources implements ECSResource
    {
        BRICKS,
        WEAPONS,
        CRYSTALS;


        public Producers getProducer() {
            return Producers.values()[this.ordinal()];
        }
    }

    public static enum CWars2Res implements ECSResource
    {
        CASTLE,
        WALL;

    }
}

