/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.core.replays;

import com.cardshifter.api.both.PlayerConfigMessage;
import com.cardshifter.core.replays.ReplayAction;
import com.cardshifter.core.replays.ReplayException;
import com.cardshifter.core.replays.ReplayRecordSystem;
import com.cardshifter.modapi.actions.ActionAllowedCheckEvent;
import com.cardshifter.modapi.actions.ActionComponent;
import com.cardshifter.modapi.actions.ActionPerformEvent;
import com.cardshifter.modapi.actions.Actions;
import com.cardshifter.modapi.actions.ECSAction;
import com.cardshifter.modapi.actions.SpecificActionSystem;
import com.cardshifter.modapi.actions.TargetSet;
import com.cardshifter.modapi.ai.AIComponent;
import com.cardshifter.modapi.ai.AISystem;
import com.cardshifter.modapi.base.Component;
import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.ECSSystem;
import com.cardshifter.modapi.base.Entity;
import com.cardshifter.modapi.base.PlayerComponent;
import com.cardshifter.modapi.events.StartGameEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import net.zomis.cardshifter.ecs.config.ConfigComponent;

public class ReplayPlaybackSystem
implements ECSSystem {
    private static final String NEXT_STEP = "Next Step";
    private final ReplayRecordSystem replayData;
    private int currentActionIndex;
    private final ECSGame game;

    public ReplayPlaybackSystem(ECSGame game, ReplayRecordSystem replay) {
        this.replayData = replay;
        this.game = game;
        this.applySeed(game, replay.getSeed());
    }

    private void applySeed(ECSGame game, long newSeed) {
        Random random = game.getRandom();
        try {
            Field field = random.getClass().getDeclaredField("seed");
            field.setAccessible(true);
            Object result = field.get(random);
            AtomicLong seed = (AtomicLong)result;
            seed.set(newSeed);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Cannot initialize random seed", e);
        }
    }

    public void startGame(ECSGame game) {
        game.getEntitiesWithComponent(AIComponent.class).forEach(e -> ((AIComponent)e.getComponent(AIComponent.class)).setPaused(true));
        game.getEvents().registerHandlerAfter((Object)this, StartGameEvent.class, e -> this.onStart((StartGameEvent)e, game));
        ArrayList players = new ArrayList(game.getEntitiesWithComponent(PlayerComponent.class));
        players.forEach(this::setPlayerName);
        players.forEach(this::giveReplayControls);
    }

    private void setPlayerName(Entity playerEntity) {
        PlayerComponent playerInfo = (PlayerComponent)playerEntity.getComponent(PlayerComponent.class);
        int index = playerInfo.getIndex();
        if (this.replayData.getPlayerNames() != null) {
            playerInfo.setName(this.replayData.getPlayerNames().get(index));
        }
    }

    private void onStart(StartGameEvent event, ECSGame game) {
        game.findSystemsOfClass(ReplayRecordSystem.class).forEach(arg_0 -> ((ECSGame)game).removeSystem(arg_0));
        game.findSystemsOfClass(AISystem.class).forEach(arg_0 -> ((ECSGame)game).removeSystem(arg_0));
        game.addSystem((ECSSystem)new NextStepReplayActionSystem());
    }

    private void giveReplayControls(Entity player) {
        ActionComponent actions = (ActionComponent)player.getComponent(ActionComponent.class);
        if (actions == null) {
            actions = new ActionComponent();
            player.addComponent((Component)actions);
        }
        actions.addAction(new ECSAction(player, NEXT_STEP, e -> true, this::nextStep));
    }

    private void nextStep(ECSAction replayAction) {
        if (this.isReplayFinished()) {
            return;
        }
        this.nextStep();
    }

    public boolean isReplayFinished() {
        return this.currentActionIndex >= this.replayData.getActionInformation().size();
    }

    public void nextStep() {
        ReplayAction step = this.replayData.getActionInformation().get(this.currentActionIndex);
        Entity entity = this.game.getEntity(step.getEntity());
        ECSAction action = Actions.getAction((Entity)entity, (String)step.getActionName());
        if (action.getTargetSets().size() != step.getTargets().size()) {
            throw new ReplayException("Number of targetsets does not match for action " + action + " at action index " + this.currentActionIndex);
        }
        for (int i = 0; i < action.getTargetSets().size(); ++i) {
            TargetSet targetSet = (TargetSet)action.getTargetSets().get(i);
            List<Integer> targets = step.getTargets().get(i);
            targetSet.clearTargets();
            for (int target : targets) {
                Entity targetEntity = this.game.getEntity(target);
                if (targetEntity == null) {
                    throw new ReplayException("Target " + target + " not found when performing " + action + " at action index " + this.currentActionIndex);
                }
                targetSet.addTarget(targetEntity);
            }
        }
        boolean performSuccess = action.perform(this.game.getEntity(step.getPerformer()));
        if (!performSuccess) {
            throw new ReplayException("Replay action not correctly performed " + action + " at action index " + this.currentActionIndex);
        }
        ++this.currentActionIndex;
    }

    public void setPlayerConfigs(ECSGame game) {
        for (Map.Entry<Integer, PlayerConfigMessage> storedConfig : this.replayData.getEntityConfigs().entrySet()) {
            System.out.println("Processing stored config " + storedConfig.getKey() + ": " + storedConfig.getValue());
            Entity entity = game.getEntity(storedConfig.getKey().intValue());
            ConfigComponent config = (ConfigComponent)entity.getComponent(ConfigComponent.class);
            for (Map.Entry configuration : storedConfig.getValue().getConfigs().entrySet()) {
                System.out.println("Adding config " + (String)configuration.getKey() + " of type " + configuration.getValue().getClass() + ": " + configuration.getValue());
                config.addConfig((String)configuration.getKey(), configuration.getValue());
            }
            config.setConfigured(true);
        }
    }

    private static class NextStepReplayActionSystem
    extends SpecificActionSystem {
        public NextStepReplayActionSystem() {
            super(ReplayPlaybackSystem.NEXT_STEP);
        }

        protected void isAllowed(ActionAllowedCheckEvent event) {
            event.setAllowed(event.getEntity() == event.getPerformer());
        }

        protected void onPerform(ActionPerformEvent event) {
        }
    }
}

