/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.core.replays;

import com.cardshifter.modapi.actions.ActionPerformEvent;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ReplayAction {
    private final int entity;
    private final List<List<Integer>> targets;
    private final int performer;
    private final String actionName;

    @JsonCreator
    ReplayAction() {
        this.entity = 0;
        this.targets = null;
        this.performer = 0;
        this.actionName = "N/A";
    }

    private ReplayAction(ActionPerformEvent event) {
        this.entity = event.getEntity().getId();
        this.performer = event.getPerformer().getId();
        this.actionName = event.getAction().getName();
        this.targets = event.getAction().getTargetSets().stream().map(targetSet -> targetSet.getChosenTargets().stream().map(e -> e.getId()).collect(Collectors.toList())).collect(Collectors.toList());
    }

    public int getEntity() {
        return this.entity;
    }

    public String getActionName() {
        return this.actionName;
    }

    public int getPerformer() {
        return this.performer;
    }

    public List<List<Integer>> getTargets() {
        return Collections.unmodifiableList(this.targets);
    }

    public static ReplayAction forAction(ActionPerformEvent event) {
        ReplayAction act = new ReplayAction(event);
        return act;
    }
}

