/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.core.modloader;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Properties;

final class ModLoaderHelper {
    private ModLoaderHelper() {
        throw new UnsupportedOperationException();
    }

    static String getConfigurationFileName() {
        return "configuration.properties";
    }

    static Properties getConfiguration(Path modDirectory) throws IOException {
        Objects.requireNonNull(modDirectory, "modDirectory");
        if (!Files.isDirectory(modDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("modDirectory " + modDirectory + " must be a directory");
        }
        Properties properties = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(modDirectory.resolve(ModLoaderHelper.getConfigurationFileName()).toFile());){
            properties.load(fileInputStream);
        }
        return properties;
    }
}

