/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.core.modloader;

import com.cardshifter.core.modloader.Mod;
import com.cardshifter.core.modloader.ModNotLoadableException;
import com.cardshifter.modapi.base.ECSGame;
import java.nio.file.Path;
import java.util.Objects;

public abstract class LoadableMod
implements Mod {
    protected final Path modDirectory;
    protected boolean loaded = false;

    public LoadableMod(Path modDirectory) {
        this.modDirectory = Objects.requireNonNull(modDirectory, "modDirectory");
    }

    @Override
    public String getName() {
        return this.modDirectory.getFileName().toString();
    }

    final void load() throws ModNotLoadableException {
        if (this.loaded) {
            throw new IllegalStateException("Mod " + this.getName() + " has already been loaded");
        }
        this.load0();
        this.loaded = true;
    }

    final void unload() {
        this.checkLoaded();
        this.unload0();
        this.loaded = false;
    }

    public void setupGame(ECSGame game) {
        this.checkLoaded();
        this.createGame0(game);
    }

    public void declareConfiguration(ECSGame game) {
        this.checkLoaded();
        this.declareConfiguration0(game);
    }

    private void checkLoaded() {
        if (!this.loaded) {
            throw new IllegalStateException("Mod " + this.getName() + " has not been loaded yet");
        }
    }

    protected abstract void load0() throws ModNotLoadableException;

    protected abstract void unload0();

    protected abstract void createGame0(ECSGame var1);

    protected abstract void declareConfiguration0(ECSGame var1);
}

