/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.core.modloader;

import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.ECSMod;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class JavaScriptMod
implements ECSMod {
    private final ScriptEngine engine;
    private final Exception exception;
    private final Invocable invocable;

    public JavaScriptMod(String name, ScriptEngineManager scripts) {
        Exception exception;
        this.engine = scripts.getEngineByName("nashorn");
        this.invocable = (Invocable)((Object)this.engine);
        try {
            this.engine.eval(new InputStreamReader((InputStream)new FileInputStream(name), StandardCharsets.UTF_8));
            exception = null;
        }
        catch (ScriptException e) {
            exception = e;
        }
        catch (FileNotFoundException e) {
            exception = e;
        }
        this.exception = exception;
    }

    public void declareConfiguration(ECSGame game) {
        if (this.exception != null) {
            throw new RuntimeException("Error initializing mod", this.exception);
        }
        try {
            this.invocable.invokeFunction("declareConfiguration", game);
        }
        catch (ScriptException e) {
            throw new RuntimeException("Error declaring configuration: " + e, e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Error declaring configuration: " + e, e);
        }
    }

    public void setupGame(ECSGame game) {
        if (this.exception != null) {
            throw new RuntimeException("Error initializing mod", this.exception);
        }
        try {
            this.invocable.invokeFunction("setupGame", game);
        }
        catch (ScriptException e) {
            throw new RuntimeException("Error setting up game", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Error setting up game", e);
        }
    }
}

