/*
 * Decompiled with CFR 0.152.
 */
package com.cardshifter.core.modloader;

import com.cardshifter.core.modloader.LoadableMod;
import com.cardshifter.core.modloader.ModLoaderHelper;
import com.cardshifter.core.modloader.ModNotLoadableException;
import com.cardshifter.core.modloader.ModURLClassLoader;
import com.cardshifter.modapi.base.ECSGame;
import com.cardshifter.modapi.base.ECSMod;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Properties;

public class JavaMod
extends LoadableMod {
    private ECSMod ecsMod;
    private ModURLClassLoader modUrlClassLoader;

    JavaMod(Path modDirectory) throws ModNotLoadableException {
        super(modDirectory);
    }

    @Override
    protected void load0() throws ModNotLoadableException {
        try {
            Properties properties = ModLoaderHelper.getConfiguration(this.modDirectory);
            String jarName = properties.getProperty("jar");
            String entryPoint = properties.getProperty("entryPoint");
            Path jarPath = this.modDirectory.resolve(jarName);
            try {
                this.modUrlClassLoader = AccessController.doPrivileged(() -> new ModURLClassLoader(new URL[]{jarPath.toUri().toURL()}, this.getClass().getClassLoader()));
            }
            catch (PrivilegedActionException ex) {
                throw new ModNotLoadableException(ex);
            }
            Class<?> clazz = Class.forName(entryPoint, false, this.modUrlClassLoader);
            if (!ECSMod.class.isAssignableFrom(clazz)) {
                throw new ModNotLoadableException(clazz + " does not implement ECSMod");
            }
            this.ecsMod = (ECSMod)clazz.newInstance();
        }
        catch (Exception ex) {
            throw new ModNotLoadableException(ex);
        }
    }

    @Override
    protected void unload0() {
        try {
            this.modUrlClassLoader.close();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    protected void createGame0(ECSGame game) {
        this.ecsMod.setupGame(game);
    }

    @Override
    protected void declareConfiguration0(ECSGame game) {
        this.ecsMod.declareConfiguration(game);
    }
}

